/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.infernalstudios.miningmaster.containers.GemForgeContainer;

public class UpdateGemForgePacket {
    private final boolean isActive;

    public UpdateGemForgePacket(boolean isActive) {
        this.isActive = isActive;
    }

    public static void encode(UpdateGemForgePacket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.isActive);
    }

    public static UpdateGemForgePacket decode(FriendlyByteBuf buffer) {
        return new UpdateGemForgePacket(buffer.readBoolean());
    }

    public static void handle(UpdateGemForgePacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer playerEntity = ((NetworkEvent.Context)context.get()).getSender();
            if (playerEntity != null && playerEntity.m_20194_() != null && playerEntity.f_36096_ instanceof GemForgeContainer) {
                ((GemForgeContainer)playerEntity.f_36096_).setForgeActive(message.isActive);
            }
        });
        context.get().setPacketHandled(true);
    }
}

