/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.miningmaster.init.MMRecipes;
import org.infernalstudios.miningmaster.recipes.IForgingRecipe;

public class ForgingRecipe
implements IForgingRecipe {
    private final ResourceLocation recipeId;
    private final Ingredient catalyst;
    private final NonNullList<Ingredient> recipeGems;
    private final NonNullList<Pair<Enchantment, Integer>> enchantments;
    private final ItemStack result;

    public ForgingRecipe(ResourceLocation recipeId, Ingredient catalyst, NonNullList<Ingredient> recipeGems, NonNullList<Pair<Enchantment, Integer>> enchantments, ItemStack result) {
        this.recipeId = recipeId;
        this.catalyst = catalyst;
        this.recipeGems = recipeGems;
        this.enchantments = enchantments;
        this.result = result;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        boolean catalystMatches = this.catalyst.test(inv.m_8020_(9));
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return catalystMatches && i == this.recipeGems.size() && RecipeMatcher.findMatches(inputs, this.recipeGems) != null;
    }

    public ItemStack getDefaultedOutput() {
        ItemStack itemstack = this.result.m_41777_();
        for (Pair enchantment : this.enchantments) {
            itemstack.m_41663_((Enchantment)enchantment.getFirst(), ((Integer)enchantment.getSecond()).intValue());
        }
        return itemstack;
    }

    public ItemStack m_5874_(Container inv) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundnbt = inv.m_8020_(0).m_41783_();
        if (compoundnbt != null) {
            itemstack.m_41751_(compoundnbt.m_6426_());
        }
        for (Pair enchantment : this.enchantments) {
            itemstack.m_41663_((Enchantment)enchantment.getFirst(), ((Integer)enchantment.getSecond()).intValue());
        }
        return itemstack;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.addAll(this.recipeGems);
        ingredients.add((Object)this.catalyst);
        return ingredients;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MMRecipes.FORGING_RECIPE.get();
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = GsonHelper.m_13906_((JsonObject)object, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)s));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + s + "'");
        }
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
    }

    public static class ForgingRecipeSerializer
    implements RecipeSerializer<ForgingRecipe> {
        public ForgingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> gemList = ForgingRecipeSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"gems"));
            NonNullList<Pair<Enchantment, Integer>> enchantmentList = NonNullList.m_122779_();
            if (json.has("enchantments")) {
                enchantmentList = ForgingRecipeSerializer.readEnchantments(GsonHelper.m_13933_((JsonObject)json, (String)"enchantments"));
            }
            if (gemList.isEmpty()) {
                throw new JsonParseException("No gems for forging recipe");
            }
            if (gemList.size() > 9) {
                throw new JsonParseException("Too many gems for forging recipe the max is 9");
            }
            Ingredient catalyst = Ingredient.f_43901_;
            ItemStack result = ForgingRecipe.deserializeItem(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            if (json.has("catalyst")) {
                catalyst = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"catalyst"));
            }
            return new ForgingRecipe(recipeId, catalyst, gemList, enchantmentList, result);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static NonNullList<Pair<Enchantment, Integer>> readEnchantments(JsonArray enchantmentArray) {
            NonNullList enchantments = NonNullList.m_122779_();
            for (int i = 0; i < enchantmentArray.size(); ++i) {
                Enchantment enchantment = ForgingRecipeSerializer.parseEnchantment(GsonHelper.m_13918_((JsonElement)enchantmentArray.get(i), (String)"enchantment"));
                int lvl = ForgingRecipeSerializer.parseEnchantmentLevel(GsonHelper.m_13918_((JsonElement)enchantmentArray.get(i), (String)"lvl"));
                enchantments.add((Object)new Pair((Object)enchantment, (Object)lvl));
            }
            return enchantments;
        }

        private static Enchantment parseEnchantment(JsonObject object) {
            if (object.isJsonArray()) {
                throw new JsonSyntaxException("Expected object to be a single Enchantment");
            }
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"enchantment")));
            if (enchantment == null) {
                throw new JsonSyntaxException("No valid Enchantment name supplied");
            }
            return enchantment;
        }

        private static int parseEnchantmentLevel(JsonObject object) {
            if (object.isJsonArray()) {
                throw new JsonSyntaxException("Expected object to be a single integer");
            }
            return GsonHelper.m_13927_((JsonObject)object, (String)"lvl");
        }

        @Nullable
        public ForgingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int i = buffer.m_130242_();
            NonNullList gemList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < gemList.size(); ++j) {
                gemList.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int k = buffer.m_130242_();
            NonNullList enchantmentList = NonNullList.m_122779_();
            for (int j = 0; j < k; ++j) {
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.m_130281_());
                if (enchantment == null) continue;
                enchantmentList.add((Object)new Pair((Object)enchantment, (Object)buffer.m_130242_()));
            }
            ItemStack result = buffer.m_130267_();
            return new ForgingRecipe(recipeId, catalyst, (NonNullList<Ingredient>)gemList, (NonNullList<Pair<Enchantment, Integer>>)enchantmentList, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, ForgingRecipe recipe) {
            recipe.catalyst.m_43923_(buffer);
            buffer.m_130130_(recipe.recipeGems.size());
            for (Ingredient ingredient : recipe.recipeGems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.enchantments.size());
            for (Pair enchantment : recipe.enchantments) {
                buffer.m_130085_(ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)enchantment.getFirst())));
                buffer.m_130130_(((Integer)enchantment.getSecond()).intValue());
            }
            buffer.m_130055_(recipe.result);
        }
    }

    public static class ForgingRecipeType
    implements RecipeType<ForgingRecipe> {
        public String toString() {
            return TYPE_ID.toString();
        }
    }
}

