/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.recipes;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GemForgeServerRecipePlacer<C extends Container>
implements PlaceRecipe<Integer> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final StackedContents recipeItemHelper = new StackedContents();
    protected Inventory playerInventory;
    protected RecipeBookMenu<C> recipeBookContainer;

    public GemForgeServerRecipePlacer(RecipeBookMenu<C> recipeBookContainer) {
        this.recipeBookContainer = recipeBookContainer;
    }

    protected void clear() {
        for (int i = 0; i < 10; ++i) {
            this.giveToPlayer(i);
        }
        this.recipeBookContainer.m_6650_();
    }

    protected void giveToPlayer(int slotIn) {
        ItemStack itemstack = this.recipeBookContainer.m_38853_(slotIn).m_7993_();
        if (!itemstack.m_41619_()) {
            while (itemstack.m_41613_() > 0) {
                int i = this.playerInventory.m_36050_(itemstack);
                if (i == -1) {
                    i = this.playerInventory.m_36062_();
                }
                ItemStack itemstack1 = itemstack.m_41777_();
                itemstack1.m_41764_(1);
                this.playerInventory.m_36040_(i, itemstack1);
                this.recipeBookContainer.m_38853_(slotIn).m_6201_(1);
                itemstack = this.recipeBookContainer.m_38853_(slotIn).m_7993_();
            }
        }
    }

    public void place(ServerPlayer player, @Nullable Recipe<C> recipe, boolean placeAll) {
        if (recipe != null && player.m_8952_().m_12709_(recipe)) {
            this.playerInventory = player.m_150109_();
            if (this.placeIntoInventory() || player.m_7500_()) {
                this.recipeItemHelper.m_36453_();
                player.m_150109_().m_36010_(this.recipeItemHelper);
                this.recipeBookContainer.m_5816_(this.recipeItemHelper);
                if (this.recipeItemHelper.m_36475_(recipe, null)) {
                    this.tryPlaceRecipe(recipe, placeAll);
                } else {
                    this.clear();
                    player.f_8906_.m_9829_((Packet)new ClientboundPlaceGhostRecipePacket(player.f_36096_.f_38840_, recipe));
                }
                player.m_150109_().m_6596_();
            }
        }
    }

    protected void tryPlaceRecipe(Recipe<C> recipe, boolean placeAll) {
        int j1;
        IntArrayList intlist;
        boolean flag = this.recipeBookContainer.m_6032_(recipe);
        int i = this.recipeItemHelper.m_36493_(recipe, null);
        if (flag) {
            for (int j = 0; j < 10; ++j) {
                ItemStack itemstack = this.recipeBookContainer.m_38853_(j).m_7993_();
                if (itemstack.m_41619_() || Math.min(i, itemstack.m_41741_()) >= itemstack.m_41613_() + 1) continue;
                return;
            }
        }
        if (this.recipeItemHelper.m_36478_(recipe, (IntList)(intlist = new IntArrayList()), j1 = this.getMaxAmount(placeAll, i, flag))) {
            int k = j1;
            IntListIterator intListIterator = intlist.iterator();
            while (intListIterator.hasNext()) {
                int l = (Integer)intListIterator.next();
                int i1 = StackedContents.m_36454_((int)l).m_41741_();
                if (i1 >= k) continue;
                k = i1;
            }
            if (this.recipeItemHelper.m_36478_(recipe, (IntList)intlist, k)) {
                this.clear();
                this.m_135408_(this.recipeBookContainer.m_6635_(), this.recipeBookContainer.m_6656_(), this.recipeBookContainer.m_6636_(), recipe, (Iterator<Integer>)intlist.iterator(), k);
            }
        }
    }

    protected int getMaxAmount(boolean placeAll, int maxPossible, boolean recipeMatches) {
        int i = 1;
        if (placeAll) {
            i = maxPossible;
        } else if (recipeMatches) {
            i = 64;
            for (int j = 0; j < 10; ++j) {
                ItemStack itemstack;
                if (j == this.recipeBookContainer.m_6636_() || (itemstack = this.recipeBookContainer.m_38853_(j).m_7993_()).m_41619_() || i <= itemstack.m_41613_()) continue;
                i = itemstack.m_41613_();
            }
            if (i < 64) {
                ++i;
            }
        }
        return i;
    }

    protected void consumeIngredient(Slot slotToFill, ItemStack ingredientIn) {
        ItemStack itemstack;
        int i = this.playerInventory.m_36043_(ingredientIn);
        if (i != -1 && !(itemstack = this.playerInventory.m_8020_(i).m_41777_()).m_41619_()) {
            if (itemstack.m_41613_() > 1) {
                this.playerInventory.m_7407_(i, 1);
            } else {
                this.playerInventory.m_8016_(i);
            }
            itemstack.m_41764_(1);
            if (slotToFill.m_7993_().m_41619_()) {
                slotToFill.m_5852_(itemstack);
            } else {
                slotToFill.m_7993_().m_41769_(1);
            }
        }
    }

    public void m_135408_(int width, int height, int outputSlot, Recipe<?> recipe, Iterator<Integer> ingredients, int maxAmount) {
        int i = width;
        int j = height;
        int k1 = 0;
        block0: for (int k = 0; k < height; ++k) {
            boolean flag = (float)j < (float)height / 2.0f;
            int l = Mth.m_14143_((float)((float)height / 2.0f - (float)j / 2.0f));
            if (flag && l > k) {
                k1 += width;
                ++k;
            }
            for (int i1 = 0; i1 < width; ++i1) {
                boolean flag1;
                if (!ingredients.hasNext()) {
                    return;
                }
                flag = (float)i < (float)width / 2.0f;
                l = Mth.m_14143_((float)((float)width / 2.0f - (float)i / 2.0f));
                int j1 = i;
                boolean bl = flag1 = i1 < i;
                if (flag) {
                    j1 = l + i;
                    boolean bl2 = flag1 = l <= i1 && i1 < l + i;
                }
                if (flag1) {
                    this.m_5817_(ingredients, k1, maxAmount, k, i1);
                } else if (j1 == i1) {
                    k1 += width - i1;
                    continue block0;
                }
                ++k1;
            }
        }
    }

    public void m_5817_(Iterator<Integer> ingredients, int slotIn, int maxAmount, int y, int x) {
        ItemStack itemstack = StackedContents.m_36454_((int)ingredients.next());
        Slot slot = ingredients.hasNext() ? (Slot)this.recipeBookContainer.f_38839_.get(slotIn) : (Slot)this.recipeBookContainer.f_38839_.get(this.recipeBookContainer.m_6636_());
        if (!itemstack.m_41619_()) {
            for (int i = 0; i < maxAmount; ++i) {
                this.consumeIngredient(slot, itemstack);
            }
        }
    }

    private boolean placeIntoInventory() {
        ArrayList list = Lists.newArrayList();
        int i = this.getEmptyPlayerSlots();
        for (int j = 0; j < 10; ++j) {
            ItemStack itemstack = this.recipeBookContainer.m_38853_(j).m_7993_().m_41777_();
            if (itemstack.m_41619_()) continue;
            int k = this.playerInventory.m_36050_(itemstack);
            if (k == -1 && list.size() <= i) {
                for (ItemStack itemstack1 : list) {
                    if (!itemstack1.m_41656_(itemstack) || itemstack1.m_41613_() == itemstack1.m_41741_() || itemstack1.m_41613_() + itemstack.m_41613_() > itemstack1.m_41741_()) continue;
                    itemstack1.m_41769_(itemstack.m_41613_());
                    itemstack.m_41764_(0);
                    break;
                }
                if (itemstack.m_41619_()) continue;
                if (list.size() >= i) {
                    return false;
                }
                list.add(itemstack);
                continue;
            }
            if (k != -1) continue;
            return false;
        }
        return true;
    }

    private int getEmptyPlayerSlots() {
        int i = 0;
        for (ItemStack itemstack : this.playerInventory.f_35974_) {
            if (!itemstack.m_41619_()) continue;
            ++i;
        }
        return i;
    }
}

