/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.miningmaster.init.MMRecipes;

public class GemSmithingRecipe
extends UpgradeRecipe
implements Recipe<Container> {
    private final Ingredient blacklist;
    private final ItemStack gem;
    private final NonNullList<Enchantment> enchantments;
    private final ResourceLocation recipeId;

    public GemSmithingRecipe(ResourceLocation recipeId, Ingredient blacklist, ItemStack gem, NonNullList<Enchantment> enchantments) {
        super(recipeId, blacklist, Ingredient.f_43901_, ItemStack.f_41583_);
        this.recipeId = recipeId;
        this.blacklist = blacklist;
        this.gem = gem;
        this.enchantments = enchantments;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return !this.blacklist.test(inv.m_8020_(0)) && this.gem.m_41656_(inv.m_8020_(1)) && this.m_5874_(inv) != null;
    }

    public ItemStack m_5874_(Container inv) {
        ItemStack itemstack = inv.m_8020_(0).m_41777_();
        CompoundTag compoundnbt = inv.m_8020_(0).m_41783_();
        if (itemstack.m_150930_(Items.f_41852_)) {
            return null;
        }
        if (compoundnbt != null) {
            itemstack.m_41751_(compoundnbt.m_6426_());
        }
        boolean itemEnchanted = false;
        block0: for (Enchantment enchantment : this.enchantments) {
            if (!enchantment.m_6081_(itemstack) || !this.areEnchantsCompatible(itemstack, enchantment)) continue;
            ListTag nbtList = itemstack.m_41785_();
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag idTag = nbtList.m_128728_(i);
                if (!idTag.m_128461_("id").equals(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString())) continue;
                int targetLevel = idTag.m_128451_("lvl") + 1;
                if (targetLevel > enchantment.m_6586_()) break block0;
                itemEnchanted = true;
                nbtList.remove(i);
                itemstack.m_41663_(enchantment, targetLevel);
                break block0;
            }
            itemEnchanted = true;
            itemstack.m_41663_(enchantment, 1);
            break;
        }
        return itemEnchanted ? itemstack : null;
    }

    private boolean areEnchantsCompatible(ItemStack itemStack, Enchantment enchant) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        for (Enchantment e : map.keySet()) {
            if (enchant == e || enchant.m_44695_(e)) continue;
            return false;
        }
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MMRecipes.GEM_SMITHING_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44113_;
    }

    public boolean m_5598_() {
        return true;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = GsonHelper.m_13906_((JsonObject)object, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)s));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + s + "'");
        }
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
    }

    public static class GemSmithingRecipeSerializer
    implements RecipeSerializer<GemSmithingRecipe> {
        private static NonNullList<Enchantment> readEnchantments(JsonArray enchantmentArray) {
            NonNullList enchantments = NonNullList.m_122779_();
            for (int i = 0; i < enchantmentArray.size(); ++i) {
                Enchantment enchantment = GemSmithingRecipeSerializer.parseEnchantment(enchantmentArray.get(i));
                enchantments.add((Object)enchantment);
            }
            return enchantments;
        }

        private static Enchantment parseEnchantment(JsonElement element) {
            if (element.isJsonArray()) {
                throw new JsonSyntaxException("Expected object to be a single Enchantment");
            }
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13805_((JsonElement)element, (String)"enchantment")));
            if (enchantment == null) {
                throw new JsonSyntaxException("No valid Enchantment name supplied");
            }
            return enchantment;
        }

        public GemSmithingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"blacklist"));
            ItemStack gem = GemSmithingRecipe.deserializeItem(GsonHelper.m_13930_((JsonObject)json, (String)"gem"));
            NonNullList<Enchantment> enchantmentList = GemSmithingRecipeSerializer.readEnchantments(GsonHelper.m_13933_((JsonObject)json, (String)"enchantments"));
            if (enchantmentList.isEmpty()) {
                throw new JsonParseException("No enchantments for smithing recipe");
            }
            return new GemSmithingRecipe(recipeId, ingredient, gem, enchantmentList);
        }

        @Nullable
        public GemSmithingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack gem = buffer.m_130267_();
            int k = buffer.m_130242_();
            NonNullList enchantmentList = NonNullList.m_122779_();
            for (int j = 0; j < k; ++j) {
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.m_130281_());
                if (enchantment == null) continue;
                enchantmentList.add((Object)enchantment);
            }
            return new GemSmithingRecipe(recipeId, ingredient, gem, (NonNullList<Enchantment>)enchantmentList);
        }

        public void toNetwork(FriendlyByteBuf buffer, GemSmithingRecipe recipe) {
            recipe.blacklist.m_43923_(buffer);
            buffer.m_130055_(recipe.gem);
            buffer.m_130130_(recipe.enchantments.size());
            for (Enchantment enchantment : recipe.enchantments) {
                buffer.m_130085_(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment));
            }
        }
    }
}

