/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.tileentities;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.infernalstudios.miningmaster.blocks.GemForgeBlock;
import org.infernalstudios.miningmaster.containers.GemForgeContainer;
import org.infernalstudios.miningmaster.init.MMRecipes;
import org.infernalstudios.miningmaster.init.MMSounds;
import org.infernalstudios.miningmaster.init.MMTags;
import org.infernalstudios.miningmaster.init.MMTileEntityTypes;
import org.infernalstudios.miningmaster.recipes.ForgingRecipe;

public class GemForgeTileEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int FORGE_TIME_TOTAL = 300;
    @Nullable
    protected Component customName;
    private final ItemStackHandler inventory = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            GemForgeTileEntity.this.m_6596_();
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    private int forgeTime = 0;
    private boolean forgeActive;
    private boolean recipeValid;
    protected final ContainerData forgeData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return GemForgeTileEntity.this.forgeActive ? 1 : 0;
                }
                case 1: {
                    return GemForgeTileEntity.this.recipeValid ? 1 : 0;
                }
                case 2: {
                    return GemForgeTileEntity.this.forgeTime;
                }
                case 3: {
                    return 300;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int k) {
            switch (index) {
                case 0: {
                    boolean bl = GemForgeTileEntity.this.forgeActive = k == 1;
                    if (GemForgeTileEntity.this.f_58857_.m_5776_()) break;
                    GemForgeTileEntity.this.f_58857_.m_5594_(null, GemForgeTileEntity.this.f_58858_, (SoundEvent)MMSounds.GEM_FORGE_COOK.get(), SoundSource.BLOCKS, 1.0f, GemForgeTileEntity.this.f_58857_.m_213780_().m_188501_() * 0.4f + 1.0f);
                    break;
                }
                case 1: {
                    GemForgeTileEntity.this.recipeValid = k == 1;
                }
                case 2: {
                    GemForgeTileEntity.this.forgeTime = k;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private static final int[] SLOTS_UP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] SLOTS_DOWN = new int[]{9};
    private static final int[] SLOTS_HORIZONTAL = new int[]{9};
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public GemForgeTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MMTileEntityTypes.GEM_FORGE_TILE_ENTITY.get(), pos, state);
    }

    public static void tickForge(Level level, BlockPos pos, BlockState state, GemForgeTileEntity gemForge) {
        boolean flag = gemForge.isForging();
        boolean flag1 = false;
        if (gemForge.isForging()) {
            ++gemForge.forgeTime;
        }
        if (!level.f_46443_) {
            ForgingRecipe recipe = level.m_7465_().m_44015_(MMRecipes.FORGING_RECIPE_TYPE, (Container)gemForge, level).orElse(null);
            gemForge.recipeValid = gemForge.canForge(recipe);
            if (gemForge.recipeValid && gemForge.forgeActive) {
                ++gemForge.forgeTime;
                if (gemForge.forgeTime >= 300) {
                    gemForge.forgeTime = 0;
                    gemForge.forge(recipe);
                    flag1 = true;
                }
            } else {
                gemForge.forgeActive = false;
                gemForge.forgeTime = 0;
            }
            if (flag != gemForge.isForging()) {
                flag1 = true;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)GemForgeBlock.LIT, (Comparable)Boolean.valueOf(gemForge.isForging())), 3);
            }
        }
        if (flag1) {
            gemForge.m_6596_();
        }
    }

    private boolean isForging() {
        return this.forgeTime > 0;
    }

    public void m_58638_(Component name) {
        this.customName = name;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("inv"));
        CompoundTag compoundnbt = nbt.m_128469_("RecipesUsed");
        this.forgeActive = nbt.m_128471_("ForgeActive");
        this.recipeValid = nbt.m_128471_("RecipeValid");
        for (String s : compoundnbt.m_128431_()) {
            this.recipes.put((Object)new ResourceLocation(s), compoundnbt.m_128451_(s));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        CompoundTag compoundnbt = new CompoundTag();
        this.recipes.forEach((recipeId, craftedAmount) -> compoundnbt.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundnbt);
        compound.m_128379_("ForgeActive", this.forgeActive);
        compound.m_128379_("RecipeValid", this.recipeValid);
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inv) {
        return new GemForgeContainer(id, inv, this.inventory, this.forgeData);
    }

    public Component m_5446_() {
        return this.customName != null ? this.customName : Component.m_237115_((String)"miningmaster:container.gem_forge");
    }

    protected Component m_6820_() {
        return null;
    }

    protected boolean canForge(@Nullable ForgingRecipe recipeIn) {
        if (recipeIn != null) {
            ItemStack result = recipeIn.m_5874_((Container)this);
            return !result.m_41619_();
        }
        return false;
    }

    private void forge(@Nullable ForgingRecipe recipe) {
        if (recipe != null && this.canForge(recipe)) {
            ItemStack result = recipe.m_5874_((Container)this);
            this.inventory.setStackInSlot(9, result.m_41777_());
            if (!this.f_58857_.f_46443_) {
                this.m_6029_(recipe);
            }
            for (int i = 0; i < 9; ++i) {
                this.m_7407_(i, 1);
            }
            this.forgeActive = false;
            if (!this.f_58857_.m_5776_()) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.8f + 0.25f);
            }
        }
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !stack.m_204117_(MMTags.Items.GEMS) && !stack.m_204117_(MMTags.Items.CATALYSTS);
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < 10; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return !this.inventory.getStackInSlot(index).m_41619_() && count > 0 ? this.inventory.getStackInSlot(index).m_41620_(count) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemStack = this.inventory.getStackInSlot(index);
        this.inventory.setStackInSlot(index, ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.setStackInSlot(index, stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            System.out.println(false);
            return false;
        }
        System.out.println(true);
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (this.m_8020_(index).m_41613_() != 0) {
            return false;
        }
        if (index < 9) {
            return stack.m_204117_(MMTags.Items.GEMS);
        }
        return stack.m_204117_(MMTags.Items.CATALYSTS);
    }

    public void m_6211_() {
        for (int i = 0; i < 10; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_5809_(StackedContents helper) {
        for (int i = 0; i < 10; ++i) {
            helper.m_36491_(this.inventory.getStackInSlot(i));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

