/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;
import org.infernalstudios.miningmaster.init.MMBlocks;
import org.infernalstudios.miningmaster.world.features.config.MalachiteMeteoriteFeatureConfig;

public class MalachiteMeteoriteFeature
extends Feature<MalachiteMeteoriteFeatureConfig> {
    public MalachiteMeteoriteFeature(Codec<MalachiteMeteoriteFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<MalachiteMeteoriteFeatureConfig> context) {
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        MalachiteMeteoriteFeatureConfig config = (MalachiteMeteoriteFeatureConfig)context.m_159778_();
        if (rand.m_188503_(100) < config.chanceToGenerate()) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.m_123341_(), 0, pos.m_123343_());
            boolean flag = true;
            while (mutable.m_123342_() <= level.m_151558_()) {
                BlockState state = level.m_8055_((BlockPos)mutable);
                if (!state.m_60795_()) {
                    flag = false;
                    break;
                }
                mutable.m_122173_(Direction.UP);
            }
            if (flag) {
                float islandRadius = rand.m_188503_(config.maxRadius() - config.minRadius()) + config.minRadius();
                double meteoriteRadius = (double)(islandRadius / (float)(rand.m_188503_(2) + 2) + (float)rand.m_188503_(3)) + 0.5;
                double meteoriteOffset = (double)rand.m_188503_(2 * (int)meteoriteRadius / 3) - meteoriteRadius / 3.0;
                this.generateIsland(level, rand, pos, islandRadius);
                this.generateImpactCrater(level, rand, pos, meteoriteOffset, meteoriteRadius);
                this.generateMeteorite(level, rand, pos, meteoriteOffset, meteoriteRadius);
                this.scatterCrust(level, rand, pos, meteoriteRadius + (double)rand.m_188503_(3) + 3.0, islandRadius);
                return true;
            }
        }
        return false;
    }

    private void generateIsland(WorldGenLevel world, RandomSource rand, BlockPos pos, float islandRadius) {
        int i = 0;
        while (islandRadius > 0.5f) {
            for (int j = Mth.m_14143_((float)(-islandRadius)); j <= Mth.m_14167_((float)islandRadius); ++j) {
                for (int k = Mth.m_14143_((float)(-islandRadius)); k <= Mth.m_14167_((float)islandRadius); ++k) {
                    if (!((float)(j * j + k * k) <= (islandRadius + 1.0f) * (islandRadius + 1.0f))) continue;
                    this.m_5974_((LevelWriter)world, pos.m_7918_(j, i, k), Blocks.f_50259_.m_49966_());
                }
            }
            islandRadius = (float)((double)islandRadius - ((double)rand.m_188503_(2) + 0.5));
            --i;
        }
    }

    private void generateMeteorite(WorldGenLevel world, RandomSource rand, BlockPos pos, double meteoriteOffset, double meteoriteRadius) {
        Vec3 meteoritePos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_() + meteoriteOffset, (double)pos.m_123343_());
        int airCoreSize = Math.max(2, (int)meteoriteRadius / 2);
        for (double x = Math.floor(-meteoriteRadius); x <= Math.ceil(meteoriteRadius); x += 1.0) {
            for (double y = Math.floor(-meteoriteRadius); y <= Math.ceil(meteoriteRadius); y += 1.0) {
                for (double z = Math.floor(-meteoriteRadius); z <= Math.ceil(meteoriteRadius); z += 1.0) {
                    double squaring = new Vec3(x, y, z).m_82556_();
                    if (squaring > meteoriteRadius * meteoriteRadius) continue;
                    BlockPos pointPos = new BlockPos(meteoritePos.m_7096_() + x, meteoritePos.m_7098_() + y, meteoritePos.m_7094_() + z);
                    if (squaring > (meteoriteRadius - 1.0) * (meteoriteRadius - 1.0)) {
                        if (pointPos.m_123342_() <= pos.m_123342_() && rand.m_188503_(100) >= 85) continue;
                        world.m_7731_(pointPos, ((Block)MMBlocks.MALACRUST.get()).m_49966_(), 2);
                        continue;
                    }
                    if (squaring > (double)airCoreSize) {
                        world.m_7731_(pointPos, ((Block)MMBlocks.MALACORE.get()).m_49966_(), 2);
                        continue;
                    }
                    if (squaring > 0.0) {
                        world.m_7731_(pointPos, Blocks.f_50016_.m_49966_(), 2);
                        continue;
                    }
                    world.m_7731_(pointPos, ((Block)MMBlocks.AIR_MALACHITE_ORE.get()).m_49966_(), 2);
                }
            }
        }
    }

    private void generateImpactCrater(WorldGenLevel world, RandomSource rand, BlockPos pos, double meteoriteOffset, double meteoriteRadius) {
        double craterRadius = meteoriteRadius + 3.0;
        Vec3 craterPos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_() + (craterRadius - (meteoriteRadius + meteoriteOffset) + 1.0), (double)pos.m_123343_());
        for (double y = Math.floor(-craterRadius); y <= Math.ceil(craterRadius); y += 1.0) {
            for (double x = Math.floor(-craterRadius); x <= Math.ceil(craterRadius); x += 1.0) {
                for (double z = Math.floor(-craterRadius); z <= Math.ceil(craterRadius); z += 1.0) {
                    BlockPos pointPos;
                    double squaring = new Vec3(x, y, z).m_82556_();
                    if (squaring > craterRadius * craterRadius || (pointPos = new BlockPos(craterPos.m_7096_() + x, craterPos.m_7098_() + y, craterPos.m_7094_() + z)).m_123342_() > pos.m_123342_() || rand.m_188503_(5) >= 4) continue;
                    world.m_7731_(pointPos, Blocks.f_50016_.m_49966_(), 2);
                }
            }
        }
    }

    private void scatterCrust(WorldGenLevel world, RandomSource rand, BlockPos pos, double craterRadius, float islandRadius) {
        int numberOfChunks = rand.m_188503_((int)islandRadius * 15) + (int)islandRadius * 8;
        for (int i = 0; i < numberOfChunks; ++i) {
            double r = ((double)rand.m_188503_((int)((double)islandRadius - craterRadius + 1.0)) + craterRadius) * Math.sqrt(rand.m_188500_());
            double theta = rand.m_188500_() * 2.0 * Math.PI;
            double xOffset = r * Math.cos(theta);
            double zOffset = r * Math.sin(theta);
            BlockPos randPos = new BlockPos((double)pos.m_123341_() + xOffset, (double)(pos.m_123342_() + rand.m_188503_(2)), (double)pos.m_123343_() + zOffset);
            if (!(randPos.m_203198_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) >= craterRadius)) continue;
            world.m_7731_(randPos, ((Block)MMBlocks.MALACRUST.get()).m_49966_(), 2);
        }
    }
}

