/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod;

import com.mojang.logging.LogUtils;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.uraneptus.sullysmod.common.entities.CopperGolem;
import com.uraneptus.sullysmod.common.entities.Lanternfish;
import com.uraneptus.sullysmod.common.entities.Tortoise;
import com.uraneptus.sullysmod.core.SMConfig;
import com.uraneptus.sullysmod.core.data.client.SMBlockStateProvider;
import com.uraneptus.sullysmod.core.data.client.SMItemModelProvider;
import com.uraneptus.sullysmod.core.data.client.SMLangProvider;
import com.uraneptus.sullysmod.core.data.client.SMSoundDefinitionsProvider;
import com.uraneptus.sullysmod.core.data.server.SMAdvancementProvider;
import com.uraneptus.sullysmod.core.data.server.SMLootTableProvider;
import com.uraneptus.sullysmod.core.data.server.SMRecipeProvider;
import com.uraneptus.sullysmod.core.data.server.datapack_registries.SMBiomeModifiersProvider;
import com.uraneptus.sullysmod.core.data.server.datapack_registries.SMConfiguredFeatureProvider;
import com.uraneptus.sullysmod.core.data.server.datapack_registries.SMPlacedFeaturesProvider;
import com.uraneptus.sullysmod.core.data.server.modifiers.SMAdvancementModifiersProvider;
import com.uraneptus.sullysmod.core.data.server.modifiers.SMLootModifierProvider;
import com.uraneptus.sullysmod.core.data.server.tags.SMBiomeTagsProvider;
import com.uraneptus.sullysmod.core.data.server.tags.SMBlockTagsProvider;
import com.uraneptus.sullysmod.core.data.server.tags.SMEntityTagsProvider;
import com.uraneptus.sullysmod.core.data.server.tags.SMItemTagsProvider;
import com.uraneptus.sullysmod.core.integration.fd.FDCompat;
import com.uraneptus.sullysmod.core.registry.SMBrewingRecipes;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMParticleTypes;
import com.uraneptus.sullysmod.core.registry.SMPotions;
import com.uraneptus.sullysmod.core.registry.SMRecipeSerializer;
import com.uraneptus.sullysmod.core.registry.SMRecipeTypes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="sullysmod")
@Mod.EventBusSubscriber(modid="sullysmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SullysMod {
    public static final String MOD_ID = "sullysmod";
    public static final String BLUEPRINT_MOD_ID = "blueprint";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("sullysmod");
    public static final Logger LOGGER = LogUtils.getLogger();

    public static ResourceLocation modPrefix(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation blueprintPrefix(String path) {
        return new ResourceLocation(BLUEPRINT_MOD_ID, path);
    }

    public SullysMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::gatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SMConfig.SERVER);
        REGISTRY_HELPER.register(bus);
        SMParticleTypes.PARTICLES.register(bus);
        SMPotions.POTIONS.register(bus);
        SMRecipeTypes.RECIPE_TYPES.register(bus);
        SMRecipeSerializer.SERIALIZERS.register(bus);
        FDCompat.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(SMBrewingRecipes::register);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SMEntityTypes.COPPER_GOLEM.get(), CopperGolem.createAttributes().m_22265_());
        event.put((EntityType)SMEntityTypes.LANTERNFISH.get(), Lanternfish.createAttributes().m_22265_());
        event.put((EntityType)SMEntityTypes.TORTOISE.get(), Tortoise.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        boolean includeClient = event.includeClient();
        boolean includeServer = event.includeServer();
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.m_236039_(includeClient, (DataProvider)new SMBlockStateProvider(generator, fileHelper));
        generator.m_236039_(includeClient, (DataProvider)new SMItemModelProvider(generator, fileHelper));
        generator.m_236039_(includeClient, (DataProvider)new SMSoundDefinitionsProvider(generator, fileHelper));
        generator.m_236039_(includeClient, (DataProvider)new SMLangProvider(generator));
        SMBlockTagsProvider blockTagProvider = new SMBlockTagsProvider(generator, fileHelper);
        generator.m_236039_(includeServer, (DataProvider)new SMEntityTagsProvider(generator, fileHelper));
        generator.m_236039_(includeServer, (DataProvider)blockTagProvider);
        generator.m_236039_(includeServer, (DataProvider)new SMItemTagsProvider(generator, blockTagProvider, fileHelper));
        generator.m_236039_(includeServer, (DataProvider)new SMBiomeTagsProvider(generator, fileHelper));
        generator.m_236039_(includeServer, (DataProvider)new SMAdvancementModifiersProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new SMLootTableProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new SMAdvancementProvider(generator, fileHelper));
        generator.m_236039_(includeServer, (DataProvider)new SMRecipeProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new SMLootModifierProvider(generator));
        generator.m_236039_(includeServer, SMBiomeModifiersProvider.createBiomeModifiers(generator, fileHelper));
        generator.m_236039_(includeServer, SMConfiguredFeatureProvider.createConfiguredFeatures(generator, fileHelper));
        generator.m_236039_(includeServer, SMPlacedFeaturesProvider.createPlacedFeatures(generator, fileHelper));
    }
}

