/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.uraneptus.sullysmod.SullysMod;
import com.uraneptus.sullysmod.client.model.TortoiseShellModel;
import com.uraneptus.sullysmod.common.entities.TortoiseShell;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TortoiseShellRenderer<E extends TortoiseShell>
extends EntityRenderer<E> {
    public static final ResourceLocation TEXTURE = SullysMod.modPrefix("textures/entity/tortoise/tortoise.png");
    protected final TortoiseShellModel<E> model;

    public TortoiseShellRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.75f;
        this.model = new TortoiseShellModel(context.m_174023_(TortoiseShellModel.LAYER_LOCATION));
    }

    public void render(E pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, -1.0, 0.0);
        float spinTime = (float)((TortoiseShell)((Object)pEntity)).f_19797_ + pPartialTicks;
        if (((TortoiseShell)((Object)pEntity)).spinTicks > 0) {
            pMatrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), spinTime * 0.56f, false));
        }
        float hurtTime = (float)((TortoiseShell)((Object)pEntity)).getHurtTime() - pPartialTicks;
        float damage = ((TortoiseShell)((Object)pEntity)).getDamage() - pPartialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)hurtTime) * hurtTime * damage / 96.0f * (float)((TortoiseShell)((Object)pEntity)).getHurtDir()));
        }
        VertexConsumer vertexconsumer = pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity)));
        this.model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pMatrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(E pEntity) {
        return TEXTURE;
    }
}

