/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.blocks;

import com.teamabnormals.blueprint.common.block.InjectedBlock;
import com.uraneptus.sullysmod.common.entities.Tortoise;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class TortoiseEggBlock
extends InjectedBlock {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    private static final VoxelShape ONE_EGG_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS = BlockStateProperties.f_61415_;

    public TortoiseEggBlock(BlockBehaviour.Properties properties) {
        super(Items.f_42279_, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        this.destroyEgg(pLevel, pState, pPos, pEntity, 100);
        super.m_141947_(pLevel, pPos, pState, pEntity);
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (!(pEntity instanceof Zombie)) {
            this.destroyEgg(pLevel, pState, pPos, pEntity, 3);
        }
        super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
    }

    public void destroyEgg(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, int pChance) {
        if (this.canDestroyEgg(pLevel, pEntity) && !pLevel.f_46443_ && pLevel.f_46441_.m_188503_(pChance) == 0 && pState.m_60713_((Block)SMBlocks.TORTOISE_EGG.get())) {
            this.decreaseEggs(pLevel, pPos, pState);
        }
    }

    private void decreaseEggs(Level pLevel, BlockPos pPos, BlockState pState) {
        pLevel.m_5594_(null, pPos, (SoundEvent)SMSounds.TORTOISE_EGG_BREAK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)pState.m_61143_((Property)EGGS);
        if (i <= 1) {
            pLevel.m_46961_(pPos, false);
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.shouldUpdateHatchLevel((Level)pLevel) && TortoiseEggBlock.onDirt((BlockGetter)pLevel, pPos)) {
            int i = (Integer)pState.m_61143_((Property)HATCH);
            if (i < 2) {
                pLevel.m_5594_(null, pPos, (SoundEvent)SMSounds.TORTOISE_EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                pLevel.m_5594_(null, pPos, (SoundEvent)SMSounds.TORTOISE_EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7471_(pPos, false);
                for (int j = 0; j < (Integer)pState.m_61143_((Property)EGGS); ++j) {
                    pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
                    Tortoise tortoise = (Tortoise)((EntityType)SMEntityTypes.TORTOISE.get()).m_20615_((Level)pLevel);
                    if (tortoise == null) continue;
                    tortoise.m_146762_(-24000);
                    tortoise.m_7678_((double)pPos.m_123341_() + 0.3 + (double)j * 0.2, pPos.m_123342_(), (double)pPos.m_123343_() + 0.3, 0.0f, 0.0f);
                    pLevel.m_7967_((Entity)tortoise);
                }
            }
        }
    }

    public static boolean onDirt(BlockGetter pLevel, BlockPos pPos) {
        return TortoiseEggBlock.isDirt(pLevel, pPos.m_7495_());
    }

    public static boolean isDirt(BlockGetter getter, BlockPos pos) {
        return getter.m_8055_(pos).m_204336_(BlockTags.f_144274_);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (TortoiseEggBlock.onDirt((BlockGetter)pLevel, pPos) && !pLevel.f_46443_) {
            pLevel.m_46796_(2005, pPos, 0);
        }
    }

    private boolean shouldUpdateHatchLevel(Level pLevel) {
        float f = pLevel.m_46942_(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return pLevel.f_46441_.m_188503_(500) == 0;
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pTe, pStack);
        this.decreaseEggs(pLevel, pPos, pState);
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return !pUseContext.m_7078_() && pUseContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)pState.m_61143_((Property)EGGS) < 4 || super.m_6864_(pState, pUseContext);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)EGGS) + 1))) : super.m_5573_(pContext);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Integer)pState.m_61143_((Property)EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HATCH, EGGS});
    }

    private boolean canDestroyEgg(Level pLevel, Entity pEntity) {
        if (!(pEntity instanceof Tortoise) && !(pEntity instanceof Bat)) {
            if (!(pEntity instanceof LivingEntity)) {
                return false;
            }
            return pEntity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pEntity);
        }
        return false;
    }
}

