/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class CopperGolem
extends AbstractGolem
implements IAnimatable {
    public static final EntityDataAccessor<Integer> OXIDIZATION = SynchedEntityData.m_135353_(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    int cachedState = 0;
    int cachedGameTime = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)200);
    boolean isStatue;

    public CopperGolem(EntityType<? extends AbstractGolem> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        if (!this.isStatue) {
            this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
            this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
            this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OXIDIZATION, (Object)this.cachedState);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("OxidizationState", this.getOxidization());
        nbt.m_128405_("CachedGameTime", this.cachedGameTime);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setOxidization(nbt.m_128451_("OxidizationState"));
        this.cachedGameTime = nbt.m_128451_("CachedGameTime");
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        this.cachedState = (Integer)this.m_20088_().m_135370_(OXIDIZATION);
    }

    protected int m_7302_(int pAir) {
        return pAir;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public boolean m_5829_() {
        return this.isStatue;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            if (this.cachedGameTime > 0) {
                --this.cachedGameTime;
            }
            if (this.cachedGameTime == 0 && this.cachedState <= 3) {
                this.cachedGameTime = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)200);
                this.m_20088_().m_135381_(OXIDIZATION, (Object)this.cachedState++);
            }
        }
        if ((Integer)this.m_20088_().m_135370_(OXIDIZATION) == 3) {
            this.makeStatue();
        }
    }

    public void makeStatue() {
        this.isStatue = true;
        this.m_21557_(true);
        this.f_21345_.m_148096_();
        this.m_7910_(0.0f);
    }

    public <E extends IAnimatable> PlayState setAnimation(AnimationEvent<E> event) {
        boolean onGround = this.m_20096_();
        if (!((double)this.f_20924_ < 0.08) && onGround && !this.isStatue) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.copper_golem.walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(4.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 3.0f, this::setAnimation));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private void setOxidization(int state) {
        this.f_19804_.m_135381_(OXIDIZATION, (Object)state);
    }

    public int getOxidization() {
        return (Integer)this.f_19804_.m_135370_(OXIDIZATION);
    }
}

