/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Lanternfish
extends AbstractFish {
    private static final EntityDataAccessor<Integer> DATA_DARK_TICKS_REMAINING = SynchedEntityData.m_135353_(Lanternfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Lanternfish(EntityType<? extends Lanternfish> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new LightAvoidingRandomSwimmingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DARK_TICKS_REMAINING, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("DarkTicksRemaining", this.getDarkTicksRemaining());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setDarkTicks(nbt.m_128451_("DarkTicksRemaining"));
    }

    public void m_8107_() {
        super.m_8107_();
        int i = this.getDarkTicksRemaining();
        if (i > 0) {
            this.setDarkTicks(i - 1);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean flag = super.m_6469_(pSource, pAmount);
        if (flag) {
            this.setDarkTicks(100);
        }
        return flag;
    }

    private void setDarkTicks(int ticksRemaining) {
        this.f_19804_.m_135381_(DATA_DARK_TICKS_REMAINING, (Object)ticksRemaining);
    }

    public int getDarkTicksRemaining() {
        return (Integer)this.f_19804_.m_135370_(DATA_DARK_TICKS_REMAINING);
    }

    protected SoundEvent m_5699_() {
        return (SoundEvent)SMSounds.LANTERNFISH_FLOP.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SMSounds.LANTERNFISH_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SMSounds.LANTERNFISH_DEATH.get();
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)SMItems.LANTERNFISH_BUCKET.get());
    }

    public static boolean checkLanternfishSpawnRules(EntityType<? extends LivingEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        int seaLevel = level.m_5736_();
        int maxLanternfishSeaLevel = seaLevel - 47;
        return pos.m_123342_() <= maxLanternfishSeaLevel && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_) && level.m_45524_(pos, 0) == 0;
    }

    static class LightAvoidingRandomSwimmingGoal
    extends Goal {
        private final Lanternfish lanternfish;
        private double wantedX;
        private double wantedY;
        private double wantedZ;

        public LightAvoidingRandomSwimmingGoal(Lanternfish lanternfish) {
            this.lanternfish = lanternfish;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.lanternfish.m_5448_() != null) {
                return false;
            }
            if (this.lanternfish.m_9236_().m_46803_(this.lanternfish.m_20183_()) <= 0) {
                return false;
            }
            return this.setWantedPos();
        }

        protected boolean setWantedPos() {
            Vec3 vec3 = this.getPosition();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.lanternfish.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.lanternfish.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, 1.0);
        }

        @javax.annotation.Nullable
        protected Vec3 getPosition() {
            RandomSource randomsource = this.lanternfish.m_217043_();
            BlockPos blockpos = this.lanternfish.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(randomsource.m_188503_(20) - 10, randomsource.m_188503_(6) - 3, randomsource.m_188503_(20) - 10);
                if (this.lanternfish.m_9236_().m_46803_(blockpos1) > 0) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }
}

