/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import com.uraneptus.sullysmod.common.blocks.TortoiseEggBlock;
import com.uraneptus.sullysmod.core.other.tags.SMEntityTags;
import com.uraneptus.sullysmod.core.other.tags.SMItemTags;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Tortoise
extends Animal
implements IAnimatable {
    public static final EntityDataAccessor<Integer> HIDE_TIMER = SynchedEntityData.m_135353_(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAYING_EGG = SynchedEntityData.m_135353_(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int layEggCounter;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(SMItemTags.TORTOISE_FOOD);

    public Tortoise(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)SMEntityTypes.TORTOISE.get()).m_20615_((Level)level);
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.15f : 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new TortoiseBreedGoal(this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new TortoiseLayEggGoal(this, 0.5));
        this.f_21345_.m_25352_(4, (Goal)new RiderIgnoringTemptGoal((PathfinderMob)this, 0.45, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new RiderAllowingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(6, (Goal)new TortoiseLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new TortoiseLookAroundGoal(this));
    }

    protected void m_8022_() {
        boolean flag = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, true);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, true);
    }

    protected boolean m_6107_() {
        return super.m_6107_() && this.m_20160_();
    }

    public boolean m_20161_() {
        return true;
    }

    public boolean m_5829_() {
        return this.getHideTimerDuration() > 0;
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
        if (this.getHideTimerDuration() > 200) {
            super.m_147240_(pStrength, pX, pZ);
        } else {
            super.m_147240_(pStrength * 0.25, pX * 0.25, pZ * 0.25);
        }
    }

    public void m_8119_() {
        ServerLevel serverLevel;
        super.m_8119_();
        Level level = this.m_9236_();
        if (this.getHideTimerDuration() > 0) {
            this.setHideTimerDuration(this.getHideTimerDuration() - 1);
        }
        if (this.getHideTimerDuration() == 1) {
            this.m_146852_(GameEvent.f_157803_, null);
            level.m_5594_(null, this.m_20183_(), (SoundEvent)SMSounds.TORTOISE_EMERGE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        AABB hidingRange = this.m_20191_().m_82400_(8.0);
        List withinRange = level.m_45933_(null, hidingRange);
        for (Entity e : withinRange) {
            if (!e.m_6095_().m_204039_(SMEntityTags.SCARES_TORTOISES)) continue;
            if (this.getHideTimerDuration() == 0) {
                this.setHideTimerDuration(205);
                this.m_146852_(GameEvent.f_157802_, null);
                continue;
            }
            this.setHideTimerDuration(200);
        }
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_8843_(this.m_20183_())) {
            if (this.getHideTimerDuration() == 0) {
                this.setHideTimerDuration(205);
                this.m_146852_(GameEvent.f_157802_, null);
            } else {
                this.setHideTimerDuration(200);
            }
        }
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_19983_(new ItemStack((ItemLike)SMItems.TORTOISE_SCUTE.get(), 2));
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        boolean flag;
        boolean bl = flag = this.m_6898_(pPlayer.m_21120_(pHand)) || this.m_6162_();
        if (!(flag || this.m_20160_() || pPlayer.m_36341_())) {
            if (!this.f_19853_.f_46443_) {
                pPlayer.m_20329_((Entity)this);
                this.setHideTimerDuration(100);
            }
            this.m_146852_(GameEvent.f_223708_, null);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22276_, 30.0);
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.45f;
    }

    public double m_6048_() {
        if (this.m_146862_(entity -> entity instanceof Villager)) {
            if (this.getHideTimerDuration() > 1) {
                return super.m_6048_() + 0.15;
            }
            return super.m_6048_() + 0.3;
        }
        if (this.getHideTimerDuration() > 1) {
            return super.m_6048_() * 0.75;
        }
        return super.m_6048_();
    }

    @Nullable
    public Entity m_6688_() {
        return null;
    }

    public <E extends IAnimatable> PlayState setAnimation(AnimationEvent<E> event) {
        boolean onGround = this.m_20096_();
        if (!((double)this.f_20924_ < 0.08) && this.getHideTimerDuration() == 0 && onGround) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tortoise.walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.getHideTimerDuration() > 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tortoise.hide", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME).addAnimation("animation.tortoise.hiding", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.getHideTimerDuration() == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tortoise.reveal", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Level level = this.m_9236_();
        if (this.getHideTimerDuration() > 1) {
            if (source.m_19360_()) {
                level.m_5594_(null, this.m_20183_(), (SoundEvent)SMSounds.TORTOISE_HURT_HIDDEN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                this.setHideTimerDuration(200);
                return false;
            }
            this.setHideTimerDuration(200);
            return super.m_6469_(source, amount * 0.5f);
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.setHideTimerDuration(205);
        return super.m_6469_(source, amount);
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        if (this.getHideTimerDuration() > 200) {
            return this.m_6162_() ? (SoundEvent)SMSounds.BABY_TORTOISE_HURT.get() : (SoundEvent)SMSounds.TORTOISE_HURT.get();
        }
        return (SoundEvent)SMSounds.TORTOISE_HURT_HIDDEN.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SMSounds.TORTOISE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.m_6162_() ? (SoundEvent)SMSounds.BABY_TORTOISE_DEATH.get() : (SoundEvent)SMSounds.TORTOISE_DEATH.get();
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(4.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 3.0f, this::setAnimation));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int getHideTimerDuration() {
        return (Integer)this.f_19804_.m_135370_(HIDE_TIMER);
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void setHasEgg(boolean pHasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)pHasEgg);
    }

    public void setHideTimerDuration(int durationInTicks) {
        Level level = this.m_9236_();
        if (this.getHideTimerDuration() < durationInTicks || durationInTicks == this.getHideTimerDuration() - 1) {
            if (this.getHideTimerDuration() == 0) {
                level.m_5594_(null, this.m_20183_(), (SoundEvent)SMSounds.TORTOISE_HIDE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            this.f_19804_.m_135381_(HIDE_TIMER, (Object)durationInTicks);
        }
    }

    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(LAYING_EGG);
    }

    public boolean m_5957_() {
        return this.getHideTimerDuration() == 0 && !this.hasEgg() && super.m_5957_();
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    void setLayingEgg(boolean pIsDigging) {
        this.layEggCounter = pIsDigging ? 1 : 0;
        this.f_19804_.m_135381_(LAYING_EGG, (Object)pIsDigging);
    }

    public void m_8107_() {
        BlockPos blockpos;
        super.m_8107_();
        if (this.m_6084_() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0 && TortoiseEggBlock.onDirt((BlockGetter)this.f_19853_, blockpos = this.m_20183_())) {
            this.f_19853_.m_46796_(2001, blockpos, Block.m_49956_((BlockState)this.f_19853_.m_8055_(blockpos.m_7495_())));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HIDE_TIMER, (Object)0);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(LAYING_EGG, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("HideTimer", this.getHideTimerDuration());
        nbt.m_128379_("HasEgg", this.hasEgg());
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setHideTimerDuration(nbt.m_128451_("HideTimer"));
        this.setHasEgg(nbt.m_128471_("HasEgg"));
    }

    public static class TortoiseBreedGoal
    extends BreedGoal {
        private final Tortoise tortoise;

        public TortoiseBreedGoal(Tortoise tortoise, double pSpeedModifier) {
            super((Animal)tortoise, pSpeedModifier);
            this.tortoise = tortoise;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.tortoise.hasEgg() && this.tortoise.getHideTimerDuration() == 0;
        }

        protected void m_8026_() {
            ServerPlayer player = this.f_25113_.m_27592_();
            if (this.f_25115_ != null) {
                if (player == null && this.f_25115_.m_27592_() != null) {
                    player = this.f_25115_.m_27592_();
                }
                if (player != null) {
                    player.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(player, this.f_25113_, this.f_25115_, null);
                }
            }
            this.tortoise.setHasEgg(true);
            this.tortoise.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource random = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.m_188503_(7) + 1));
            }
        }
    }

    public static class TortoiseLayEggGoal
    extends MoveToBlockGoal {
        private final Tortoise tortoise;

        public TortoiseLayEggGoal(Tortoise tortoise, double pSpeedModifier) {
            super((PathfinderMob)tortoise, pSpeedModifier, 32);
            this.tortoise = tortoise;
        }

        public boolean m_8036_() {
            return this.tortoise.hasEgg() && this.tortoise.getHideTimerDuration() == 0 && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.tortoise.hasEgg() && this.tortoise.getHideTimerDuration() == 0 && super.m_8045_();
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            boolean flag = false;
            for (int i = 1; i < 9; ++i) {
                if (!level.m_8055_(pos.m_6630_(i)).m_204336_(BlockTags.f_13035_)) continue;
                flag = true;
                break;
            }
            return level.m_46859_(pos.m_7494_()) && level.m_8055_(pos).m_204336_(BlockTags.f_144274_) && flag;
        }

        public double m_8052_() {
            return 1.5;
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.tortoise.m_20069_() && this.m_25625_()) {
                if (this.tortoise.layEggCounter < 1) {
                    this.tortoise.setLayingEgg(true);
                } else if (this.tortoise.layEggCounter > this.m_183277_(200)) {
                    Level level = this.tortoise.f_19853_;
                    level.m_5594_(null, this.f_25602_, (SoundEvent)SMSounds.TORTOISE_LAY_EGG.get(), SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                    level.m_7731_(this.f_25602_.m_7494_(), (BlockState)((Block)SMBlocks.TORTOISE_EGG.get()).m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)Integer.valueOf(this.tortoise.f_19796_.m_188503_(4) + 1)), 3);
                    this.tortoise.setHasEgg(false);
                    this.tortoise.setLayingEgg(false);
                    this.tortoise.m_27601_(600);
                }
                if (this.tortoise.isLayingEgg()) {
                    ++this.tortoise.layEggCounter;
                }
            }
        }
    }

    public static class RiderIgnoringTemptGoal
    extends TemptGoal {
        public RiderIgnoringTemptGoal(PathfinderMob pMob, double pSpeedModifier, Ingredient pItems, boolean pCanScare) {
            super(pMob, pSpeedModifier, pItems, pCanScare);
        }

        public boolean m_8036_() {
            Tortoise tortoise;
            PathfinderMob pathfinderMob = this.f_25924_;
            if (pathfinderMob instanceof Tortoise && (tortoise = (Tortoise)pathfinderMob).getHideTimerDuration() > 1) {
                return false;
            }
            if (this.f_25925_ != null && this.f_25925_.m_20159_()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            Tortoise tortoise;
            PathfinderMob pathfinderMob = this.f_25924_;
            if (pathfinderMob instanceof Tortoise && (tortoise = (Tortoise)pathfinderMob).getHideTimerDuration() > 1) {
                return false;
            }
            if (this.f_25925_ != null && this.f_25925_.m_20159_()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public static class RiderAllowingRandomStrollGoal
    extends RandomStrollGoal {
        public RiderAllowingRandomStrollGoal(PathfinderMob pMob, double pSpeedModifier) {
            super(pMob, pSpeedModifier);
        }

        public boolean m_8036_() {
            Vec3 vec3;
            Tortoise tortoise;
            PathfinderMob pathfinderMob = this.f_25725_;
            if (pathfinderMob instanceof Tortoise && ((tortoise = (Tortoise)pathfinderMob).getHideTimerDuration() > 1 || tortoise.hasEgg())) {
                return false;
            }
            if (!this.f_25731_) {
                if (this.f_25725_.m_21216_() >= 100) {
                    return false;
                }
                if (this.f_25725_.m_217043_().m_188503_(RiderAllowingRandomStrollGoal.m_186073_((int)this.f_25730_)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.m_7037_()) == null) {
                return false;
            }
            this.f_25726_ = vec3.f_82479_;
            this.f_25727_ = vec3.f_82480_;
            this.f_25728_ = vec3.f_82481_;
            this.f_25731_ = false;
            return true;
        }

        public boolean m_8045_() {
            Tortoise tortoise;
            PathfinderMob pathfinderMob = this.f_25725_;
            if (pathfinderMob instanceof Tortoise && ((tortoise = (Tortoise)pathfinderMob).getHideTimerDuration() > 1 || tortoise.hasEgg())) {
                return false;
            }
            return !this.f_25725_.m_21573_().m_26571_();
        }
    }

    public static class TortoiseLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public TortoiseLookAtPlayerGoal(Mob pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance) {
            super(pMob, pLookAtType, pLookDistance);
        }

        public boolean m_8036_() {
            Tortoise tortoise;
            Mob mob = this.f_25512_;
            if (mob instanceof Tortoise && (tortoise = (Tortoise)mob).getHideTimerDuration() > 1) {
                return false;
            }
            if (this.f_25513_ != null && this.f_25513_.m_20159_()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            Tortoise tortoise;
            Mob mob = this.f_25512_;
            if (mob instanceof Tortoise && (tortoise = (Tortoise)mob).getHideTimerDuration() > 1) {
                return false;
            }
            if (this.f_25513_ != null && this.f_25513_.m_20159_()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public static class TortoiseLookAroundGoal
    extends RandomLookAroundGoal {
        private final Tortoise tortoise;

        public TortoiseLookAroundGoal(Tortoise tortoise) {
            super((Mob)tortoise);
            this.tortoise = tortoise;
        }

        public boolean m_8036_() {
            if (this.tortoise.getHideTimerDuration() > 1) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.tortoise.getHideTimerDuration() > 1) {
                return false;
            }
            return super.m_8045_();
        }
    }
}

