/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMItems;
import java.util.List;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class TortoiseShell
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int spinTicks = 0;

    public TortoiseShell(EntityType<? extends TortoiseShell> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19850_ = true;
    }

    public TortoiseShell(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends TortoiseShell>)((EntityType)SMEntityTypes.TORTOISE_SHELL.get()), level);
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    protected Vec3 m_7643_(Direction.Axis pAxis, BlockUtil.FoundRectangle pPortal) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(pAxis, pPortal));
    }

    public void setSpinTimer() {
        this.spinTicks = 18;
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        double yLookAnglePlayer = pPlayer.m_20154_().m_82507_(Direction.Axis.Y);
        double y = this.m_20184_().m_82507_(Direction.Axis.Y);
        double x = this.m_20185_() - pPlayer.m_20185_();
        double z = this.m_20189_() - pPlayer.m_20189_();
        if (y == -0.0 && !this.isInFluidType() && yLookAnglePlayer > -0.6 && yLookAnglePlayer < 0.1) {
            double d2 = Math.max(x * x + z * z, 0.001);
            this.m_20334_(x / d2 * 2.1, 0.05, z / d2 * 2.1);
            this.setSpinTimer();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource == DamageSource.f_19314_ || pSource == DamageSource.f_19307_ || pSource == DamageSource.f_19305_) {
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)this.getDropItem());
            }
            this.m_146870_();
        }
        if (pSource == DamageSource.f_19308_) {
            this.m_146870_();
        }
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            Entity entity = pSource.m_7639_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                boolean flag = player.m_150110_().f_35937_;
                if (flag || this.getDamage() > 40.0f) {
                    if (!flag && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_) && pSource != DamageSource.f_19308_ && pSource != DamageSource.f_19314_ && pSource != DamageSource.f_19305_ && pSource != DamageSource.f_19307_) {
                        this.m_19998_((ItemLike)this.getDropItem());
                    }
                    this.m_146870_();
                }
            }
            return true;
        }
        return true;
    }

    public Item getDropItem() {
        return (Item)SMItems.TORTOISE_SHELL.get();
    }

    public void m_6053_() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    protected AABB m_20217_(Pose pPose) {
        return super.m_20217_(pPose);
    }

    public AABB m_6921_() {
        return super.m_6921_();
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    private void hurtEntity(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(DamageSource.f_19318_, 4.0f);
        }
    }

    private void knockBack(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            double x = entity.m_20185_() - this.m_20185_();
            double z = entity.m_20189_() - this.m_20189_();
            double shellX = this.m_20185_() - entity.m_20185_();
            double shellZ = this.m_20189_() - entity.m_20189_();
            double d2 = Math.max(x * x + z * z, 0.001);
            this.m_20334_(shellX / d2 * 0.5, 0.005, shellZ / d2 * 0.5);
            entity.m_5997_(x / d2 * 0.05, 0.005, z / d2 * 0.05);
        }
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy)).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    private void blockKnockBack() {
        BlockPos XP = this.m_20183_().m_7918_(1, 0, 0);
        BlockPos XN = this.m_20183_().m_7918_(-1, 0, 0);
        BlockPos ZP = this.m_20183_().m_7918_(0, 0, 1);
        BlockPos ZN = this.m_20183_().m_7918_(0, 0, -1);
        BlockState blockXP = this.f_19853_.m_8055_(XP);
        BlockState blockXN = this.f_19853_.m_8055_(XN);
        BlockState blockZP = this.f_19853_.m_8055_(ZP);
        BlockState blockZN = this.f_19853_.m_8055_(ZN);
        Vec3 vec3 = this.m_20184_();
        if (blockXP.m_60819_().m_76178_() && blockXN.m_60819_().m_76178_() && blockZP.m_60819_().m_76178_() && blockZN.m_60819_().m_76178_()) {
            if (!blockXP.m_60795_() && blockXP.m_60838_((BlockGetter)this.m_9236_(), XP) && vec3.m_7096_() > 0.0) {
                this.shoot(vec3.m_82548_().f_82479_, vec3.f_82480_, vec3.f_82481_, 0.45f, 0.0f);
            }
            if (!blockXN.m_60795_() && blockXN.m_60838_((BlockGetter)this.m_9236_(), XN) && vec3.m_7096_() < 0.0) {
                this.shoot(vec3.m_82548_().f_82479_, vec3.f_82480_, vec3.f_82481_, 0.45f, 0.0f);
            }
            if (!blockZP.m_60795_() && blockZP.m_60838_((BlockGetter)this.m_9236_(), ZP)) {
                this.shoot(vec3.f_82479_, vec3.f_82480_, vec3.m_82548_().f_82481_, 0.45f, 0.0f);
            }
            if (!blockZN.m_60795_() && blockZN.m_60838_((BlockGetter)this.m_9236_(), ZN)) {
                this.shoot(vec3.f_82479_, vec3.f_82480_, vec3.m_82548_().f_82481_, 0.45f, 0.0f);
            }
        }
    }

    public void m_8119_() {
        if (this.spinTicks > 0) {
            this.hurtEntity(this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82400_(0.3), EntitySelector.f_20406_));
            this.knockBack(this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82400_(0.3), EntitySelector.f_20406_));
            this.blockKnockBack();
            --this.spinTicks;
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        if (!this.m_20068_()) {
            double yVelocity = -0.04;
            FluidType fluidType = this.getEyeInFluidType();
            if (fluidType != ForgeMod.EMPTY_TYPE.get()) {
                yVelocity *= this.getFluidMotionScale(fluidType);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, yVelocity, 0.0));
        }
        Level level = this.m_9236_();
        BlockPos bottomPosition = this.m_20099_();
        float friction = this.m_20096_() ? level.m_8055_(bottomPosition).getFriction((LevelReader)level, bottomPosition, (Entity)this) * 1.55f : 1.55f;
        float defaultFriction = this.f_19853_.m_8055_(bottomPosition).getFriction((LevelReader)level, bottomPosition, (Entity)this);
        double y = this.m_20184_().m_82507_(Direction.Axis.Y);
        if (y == -0.04 && !this.isInFluidType() && defaultFriction == 0.6f) {
            this.m_20256_(this.m_20184_().m_82542_((double)friction, 0.98, (double)friction));
        }
        if (this.isInFluidType()) {
            this.m_20256_(this.m_20184_().m_82542_(0.85, 1.0, 0.85));
        }
        if (this.m_20184_() != Vec3.f_82478_) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.m_20077_()) {
            this.m_20093_();
            this.f_19789_ *= 0.5f;
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("spinTicks", this.spinTicks);
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    public void setDamage(float pDamageTaken) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(pDamageTaken));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int pHurtTime) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)pHurtTime);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtDir(int pHurtDirection) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)pHurtDirection);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }
}

