/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.data.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMItems;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class SMLootTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> lootTables = ImmutableList.of((Object)Pair.of(SMBlockLoot::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(SMEntityLoot::new, (Object)LootContextParamSets.f_81415_));

    public SMLootTableProvider(DataGenerator pGenerator) {
        super(pGenerator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.lootTables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private static class SMEntityLoot
    extends EntityLoot {
        private static final Set<EntityType<?>> SPECIAL_LOOT_TYPES = ImmutableSet.of((Object)((EntityType)SMEntityTypes.COPPER_GOLEM.get()));

        private SMEntityLoot() {
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(entityType -> ForgeRegistries.ENTITY_TYPES.getKey(entityType) != null && "sullysmod".equals(ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135827_())).collect(Collectors.toSet());
        }

        protected boolean isNonLiving(EntityType<?> entitytype) {
            return !SPECIAL_LOOT_TYPES.contains(entitytype) && entitytype.m_20674_() == MobCategory.MISC;
        }

        protected void addTables() {
            this.m_124371_((EntityType)SMEntityTypes.LANTERNFISH.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SMItems.LANTERNFISH.get())).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f))));
            this.m_124371_((EntityType)SMEntityTypes.COPPER_GOLEM.get(), LootTable.m_79147_());
            this.m_124371_((EntityType)SMEntityTypes.TORTOISE.get(), LootTable.m_79147_());
        }
    }

    private static class SMBlockLoot
    extends BlockLoot {
        private SMBlockLoot() {
        }

        protected void addTables() {
            this.m_124175_((Block)SMBlocks.JADE_ORE.get(), SMBlockLoot::createJadeOreDrops);
            this.m_124175_((Block)SMBlocks.DEEPSLATE_JADE_ORE.get(), SMBlockLoot::createJadeOreDrops);
            this.m_124288_((Block)SMBlocks.ROUGH_JADE_BLOCK.get());
            this.m_124288_((Block)SMBlocks.ROUGH_JADE_BRICKS.get());
            this.m_124288_((Block)SMBlocks.ROUGH_JADE_TILES.get());
            this.m_124288_((Block)SMBlocks.SMOOTHED_ROUGH_JADE.get());
            this.m_124288_((Block)SMBlocks.ROUGH_JADE_BRICK_STAIRS.get());
            this.m_124288_((Block)SMBlocks.ROUGH_JADE_TILE_STAIRS.get());
            this.m_124288_((Block)SMBlocks.SMOOTHED_ROUGH_JADE_STAIRS.get());
            this.m_124175_((Block)SMBlocks.ROUGH_JADE_BRICK_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.ROUGH_JADE_TILE_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.SMOOTHED_ROUGH_JADE_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.ROUGH_JADE_BRICK_VERTICAL_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.ROUGH_JADE_TILE_VERTICAL_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.SMOOTHED_ROUGH_JADE_VERTICAL_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124288_((Block)SMBlocks.POLISHED_JADE_BLOCK.get());
            this.m_124288_((Block)SMBlocks.POLISHED_JADE_BRICKS.get());
            this.m_124288_((Block)SMBlocks.POLISHED_SMALL_JADE_BRICKS.get());
            this.m_124288_((Block)SMBlocks.POLISHED_JADE_TILES.get());
            this.m_124288_((Block)SMBlocks.POLISHED_JADE_SHINGLES.get());
            this.m_124288_((Block)SMBlocks.POLISHED_CHISELED_JADE.get());
            this.m_124288_((Block)SMBlocks.POLISHED_JADE_PILLAR.get());
            this.m_124288_((Block)SMBlocks.JADE_TOTEM.get());
            this.m_124288_((Block)SMBlocks.JADE_FLINGER_TOTEM.get());
            this.m_124288_((Block)SMBlocks.POLISHED_JADE_BRICK_STAIRS.get());
            this.m_124288_((Block)SMBlocks.POLISHED_SMALL_JADE_BRICK_STAIRS.get());
            this.m_124288_((Block)SMBlocks.POLISHED_JADE_TILE_STAIRS.get());
            this.m_124288_((Block)SMBlocks.POLISHED_JADE_SHINGLE_STAIRS.get());
            this.m_124175_((Block)SMBlocks.POLISHED_JADE_BRICK_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.POLISHED_SMALL_JADE_BRICK_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.POLISHED_JADE_TILE_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.POLISHED_JADE_SHINGLE_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.POLISHED_JADE_BRICK_VERTICAL_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.POLISHED_SMALL_JADE_BRICK_VERTICAL_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.POLISHED_JADE_TILE_VERTICAL_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)SMBlocks.POLISHED_JADE_SHINGLE_VERTICAL_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124288_((Block)SMBlocks.COPPER_BUTTON.get());
            this.m_124288_((Block)SMBlocks.EXPOSED_COPPER_BUTTON.get());
            this.m_124288_((Block)SMBlocks.WEATHERED_COPPER_BUTTON.get());
            this.m_124288_((Block)SMBlocks.OXIDIZED_COPPER_BUTTON.get());
            this.m_124288_((Block)SMBlocks.WAXED_COPPER_BUTTON.get());
            this.m_124288_((Block)SMBlocks.WAXED_EXPOSED_COPPER_BUTTON.get());
            this.m_124288_((Block)SMBlocks.WAXED_WEATHERED_COPPER_BUTTON.get());
            this.m_124288_((Block)SMBlocks.WAXED_OXIDIZED_COPPER_BUTTON.get());
            this.m_124272_((Block)SMBlocks.TORTOISE_EGG.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return SMBlocks.HELPER.getDeferredRegister().getEntries().stream().map(RegistryObject::get)::iterator;
        }

        protected static LootTable.Builder createJadeOreDrops(Block block) {
            return SMBlockLoot.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)SMBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)SMItems.ROUGH_JADE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)))));
        }
    }
}

