/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.data.server.datapack_registries;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.uraneptus.sullysmod.SullysMod;
import com.uraneptus.sullysmod.core.data.SMDatagenUtil;
import com.uraneptus.sullysmod.core.other.tags.SMBiomeTags;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class SMBiomeModifiersProvider {
    private static final Map<ResourceLocation, BiomeModifier> ENTRIES = new HashMap<ResourceLocation, BiomeModifier>();

    public static JsonCodecProvider<BiomeModifier> createBiomeModifiers(DataGenerator generator, ExistingFileHelper fileHelper) {
        SMBiomeModifiersProvider.addFeatureModifier("jade_ore", SMBiomeTags.JADE_GENERATES_IN, GenerationStep.Decoration.UNDERGROUND_ORES);
        SMBiomeModifiersProvider.addSingleSpawnModifier("lanternfish", SMBiomeTags.LANTERNFISH_SPAWN_IN, (EntityType)SMEntityTypes.LANTERNFISH.get(), 10, 1, 2);
        SMBiomeModifiersProvider.addSingleSpawnModifier("tortoise", SMBiomeTags.TORTOISES_SPAWN_IN, (EntityType)SMEntityTypes.TORTOISE.get(), 5, 1, 3);
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)fileHelper, (String)"sullysmod", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)SMDatagenUtil.REGISTRY_ACCESS), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, ENTRIES);
    }

    private static void addFeatureModifier(String name, TagKey<Biome> biomeTag, GenerationStep.Decoration decorationStep) {
        SMBiomeModifiersProvider.addEntry(name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named(SMDatagenUtil.BIOME_REGISTRY, biomeTag), SMDatagenUtil.getPlacementHolder(name), decorationStep));
    }

    private static void addSingleSpawnModifier(String name, TagKey<Biome> biomeTag, EntityType<?> entity, int weight, int minCount, int maxCount) {
        SMBiomeModifiersProvider.addEntry(name, (BiomeModifier)ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)new HolderSet.Named(SMDatagenUtil.BIOME_REGISTRY, biomeTag), (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData(entity, weight, minCount, maxCount)));
    }

    private static void addEntry(String name, BiomeModifier modifier) {
        ENTRIES.put(SullysMod.modPrefix(name), modifier);
    }
}

