/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.events;

import com.uraneptus.sullysmod.common.blocks.JadeFlingerTotem;
import com.uraneptus.sullysmod.common.entities.Tortoise;
import com.uraneptus.sullysmod.common.entities.goals.GenericMobAttackTortoiseEggGoal;
import com.uraneptus.sullysmod.common.particletypes.DirectionParticleOptions;
import com.uraneptus.sullysmod.core.SMConfig;
import com.uraneptus.sullysmod.core.other.tags.SMBlockTags;
import com.uraneptus.sullysmod.core.other.tags.SMEntityTags;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMParticleTypes;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sullysmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SMEntityEvents {
    @SubscribeEvent
    public static void onProjectileHitsBlock(ProjectileImpactEvent event) {
        Player player;
        EntityHitResult entityHitResult;
        Entity blockState;
        Projectile projectile = event.getProjectile();
        Level level = event.getEntity().m_9236_();
        HitResult hitResult = event.getRayTraceResult();
        Vec3 vec3 = projectile.m_20184_();
        float velocity = (float)vec3.m_82553_();
        boolean flingerFlag = false;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = blockHitResult.m_82425_();
                blockState = level.m_8055_(pos);
                Direction direction = blockHitResult.m_82434_();
                if (blockState.m_204336_(SMBlockTags.PROJECTILES_BOUNCE_ON)) {
                    Direction front;
                    if (!projectile.m_6095_().m_204039_(SMEntityTags.CANNOT_BE_FLUNG) && blockState.m_60734_() instanceof JadeFlingerTotem && !direction.equals((Object)(front = (Direction)blockState.m_61143_((Property)JadeFlingerTotem.f_54117_)))) {
                        flingerFlag = true;
                    }
                    if (flingerFlag) {
                        event.setCanceled(true);
                        front = (Direction)blockState.m_61143_((Property)JadeFlingerTotem.f_54117_);
                        Projectile oldProjectile = projectile;
                        projectile = (Projectile)projectile.m_6095_().m_20615_(level);
                        if (projectile == null) {
                            return;
                        }
                        oldProjectile.m_142467_(Entity.RemovalReason.DISCARDED);
                        CompoundTag compoundtag = oldProjectile.m_20240_(new CompoundTag());
                        compoundtag.m_128473_("Motion");
                        projectile.m_20258_(compoundtag);
                        projectile.m_6027_((double)pos.m_123341_() + 0.5 + (double)front.m_122429_(), (double)((float)pos.m_123342_() + 0.5f + (float)front.m_122430_()), (double)pos.m_123343_() + 0.5 + (double)front.m_122431_());
                        projectile.m_6686_((double)front.m_122429_(), (double)front.m_122430_(), (double)front.m_122431_(), velocity, 0.0f);
                        level.m_7967_((Entity)projectile);
                        level.m_5594_(null, pos, (SoundEvent)SMSounds.FLINGER_FLINGS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        projectile.m_146850_(GameEvent.f_157778_);
                    } else if (!projectile.m_6095_().m_204039_(SMEntityTags.CANNOT_BOUNCE)) {
                        event.setCanceled(true);
                        switch (direction.m_122434_()) {
                            case X: {
                                projectile.m_6686_(vec3.m_82548_().f_82479_, vec3.f_82480_, vec3.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                                break;
                            }
                            case Y: {
                                projectile.m_6686_(vec3.f_82479_, vec3.m_82548_().f_82480_, vec3.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                                break;
                            }
                            case Z: {
                                projectile.m_6686_(vec3.f_82479_, vec3.f_82480_, vec3.m_82548_().f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                            }
                        }
                        projectile.m_146850_(GameEvent.f_157778_);
                        Vec3 particlePos = new Vec3(blockHitResult.m_82450_().f_82479_, blockHitResult.m_82450_().f_82480_, blockHitResult.m_82450_().f_82481_);
                        particlePos = particlePos.m_231075_(direction, 0.1);
                        level.m_7106_((ParticleOptions)new DirectionParticleOptions((ParticleType<DirectionParticleOptions>)((ParticleType)SMParticleTypes.RICOCHET.get()), direction), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                        level.m_7785_(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (SoundEvent)SMSounds.JADE_RICOCHET.get(), SoundSource.BLOCKS, 1.0f, 0.0f, false);
                    }
                }
            }
        }
        if (!level.m_5776_() && hitResult instanceof EntityHitResult && (blockState = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof Player && (player = (Player)blockState).m_21254_() && player.m_21211_().m_150930_((Item)SMItems.JADE_SHIELD.get()) && !projectile.m_6095_().m_204039_(SMEntityTags.CANNOT_BOUNCE)) {
            event.setCanceled(true);
            Direction direction = projectile.m_6350_();
            Vec3 angle = player.m_20154_();
            Projectile oldProjectile = projectile;
            projectile = (Projectile)projectile.m_6095_().m_20615_(level);
            if (projectile == null) {
                return;
            }
            oldProjectile.m_142467_(Entity.RemovalReason.DISCARDED);
            CompoundTag compoundtag = oldProjectile.m_20240_(new CompoundTag());
            compoundtag.m_128473_("Motion");
            projectile.m_20258_(compoundtag);
            projectile.m_6686_(angle.f_82479_, angle.f_82480_, angle.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
            level.m_7967_((Entity)projectile);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SMSounds.JADE_RICOCHET.get(), player.m_5720_(), 1.0f, 0.0f);
            ((ServerLevel)level).m_8767_((ParticleOptions)new DirectionParticleOptions((ParticleType<DirectionParticleOptions>)((ParticleType)SMParticleTypes.RICOCHET.get()), direction), projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            player.m_21211_().m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_().m_204039_(SMEntityTags.ATTACKS_BABY_TORTOISES) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob instanceof Ocelot) {
                Ocelot ocelot = (Ocelot)mob;
                ocelot.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Tortoise.class, 10, false, false, Turtle.f_30122_));
            } else if (mob instanceof TamableAnimal) {
                TamableAnimal tamable = (TamableAnimal)mob;
                if (!tamable.m_21824_()) {
                    tamable.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal(tamable, Tortoise.class, false, Turtle.f_30122_));
                }
            } else {
                mob.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal(mob, Tortoise.class, 10, true, false, Turtle.f_30122_));
            }
        }
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.f_21345_.m_25352_(4, (Goal)new GenericMobAttackTortoiseEggGoal((PathfinderMob)zombie, 1.0, 3));
        }
    }

    private static float calculateBounceVelocity(float velocity) {
        if (((Boolean)SMConfig.ENABLE_DYNAMIC_VELOCITY.get()).booleanValue() && velocity * 0.8f >= 0.5f) {
            return velocity * 0.8f;
        }
        return 0.5f;
    }
}

