/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.events;

import com.uraneptus.sullysmod.common.recipes.GrindstonePolishingRecipe;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sullysmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SMPlayerEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        Block block = level.m_8055_(pos).m_60734_();
        RandomSource random = level.m_213780_();
        Direction face = event.getFace();
        if (block instanceof GrindstoneBlock) {
            ArrayList<GrindstonePolishingRecipe> recipes = new ArrayList<GrindstonePolishingRecipe>(GrindstonePolishingRecipe.getRecipes(level));
            for (GrindstonePolishingRecipe polishingRecipe : recipes) {
                for (ItemStack ingredient : ((Ingredient)polishingRecipe.m_7527_().iterator().next()).m_43908_()) {
                    ItemStack itemInHand = player.m_21120_(hand);
                    ItemStack result = polishingRecipe.m_8043_();
                    int resultCount = polishingRecipe.getResultCount();
                    int xpAmount = polishingRecipe.getExperience();
                    if (!itemInHand.m_150930_(ingredient.m_41720_())) continue;
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.FAIL);
                    ItemStack resultItem = result.m_41777_();
                    if (player.m_6144_()) {
                        int ingredientCount = itemInHand.m_41613_();
                        if (!player.m_150110_().f_35937_) {
                            itemInHand.m_41774_(ingredientCount);
                        }
                        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount * ingredientCount))) {
                            player.m_36176_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount * ingredientCount), false);
                        }
                        if (xpAmount != 0) {
                            for (int i = 0; i <= ingredientCount; ++i) {
                                int dropXp = random.m_188503_(2);
                                if (dropXp >= 1) continue;
                                xpAmount += polishingRecipe.getExperience();
                            }
                            level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), xpAmount));
                        }
                    } else {
                        int canDropXp;
                        resultItem.m_41764_(resultCount);
                        if (!player.m_150110_().f_35937_) {
                            itemInHand.m_41774_(1);
                        }
                        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount))) {
                            player.m_36176_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount), false);
                        }
                        if (xpAmount != 0 && (canDropXp = random.m_188503_(2)) < 1) {
                            level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), xpAmount));
                        }
                    }
                    player.m_6674_(hand);
                    ParticleUtils.m_216318_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123797_, (IntProvider)UniformInt.m_146622_((int)1, (int)4), (Direction)event.getFace(), () -> new Vec3(player.m_20154_().m_7096_() + Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5), 0.8, player.m_20154_().m_7094_() + Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5)), (double)0.55);
                    ParticleUtils.m_216318_((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemInHand), (IntProvider)UniformInt.m_146622_((int)1, (int)2), (Direction)event.getFace(), () -> new Vec3(Mth.m_216263_((RandomSource)random, (double)-0.05, (double)0.05), 0.0, Mth.m_216263_((RandomSource)random, (double)-0.05, (double)0.05)), (double)0.55);
                    level.m_5594_(player, pos, (SoundEvent)SMSounds.POLISH_JADE.get(), SoundSource.BLOCKS, 0.5f, 0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        ItemStack item = event.getItemStack();
        if (item.m_150930_((Item)SMItems.JADE_SHIELD.get())) {
            item.m_41654_(ItemStack.TooltipPart.MODIFIERS);
        }
        if (player != null) {
            ArrayList<GrindstonePolishingRecipe> recipes = new ArrayList<GrindstonePolishingRecipe>(GrindstonePolishingRecipe.getRecipes(player.m_9236_()));
            for (GrindstonePolishingRecipe polishingRecipe : recipes) {
                for (ItemStack itemStack : ((Ingredient)polishingRecipe.m_7527_().iterator().next()).m_43908_()) {
                    if (!item.m_150930_(itemStack.m_41720_())) continue;
                    Style polishingStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7F7F7F)).m_131155_(Boolean.valueOf(true));
                    event.getToolTip().add(Component.m_237115_((String)"sullysmod.polishing.tooltip").m_6270_(polishingStyle));
                }
            }
        }
    }
}

