/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.teamabnormals.boatload.client.model.FurnaceBoatModel;
import com.teamabnormals.boatload.common.entity.vehicle.FurnaceBoat;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.other.BoatloadModelLayers;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FurnaceBoatRenderer
extends EntityRenderer<FurnaceBoat> {
    private final Map<BoatloadBoatType, Pair<ResourceLocation, FurnaceBoatModel>> boatResources;

    public FurnaceBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)BoatloadBoatType.values().stream().collect(ImmutableMap.toImmutableMap(type -> type, boatType -> Pair.of((Object)new ResourceLocation(boatType.registryName().m_135827_(), "textures/entity/furnace_boat/" + boatType.registryName().m_135815_()), (Object)((Object)new FurnaceBoatModel(context.m_174023_(BoatloadModelLayers.createFurnaceBoatModelName(boatType)))))));
    }

    public void render(FurnaceBoat entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float f2;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.375, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float f = (float)entityIn.m_38385_() - partialTicks;
        float f1 = entityIn.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entityIn.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entityIn.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStackIn.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entityIn.m_38352_(partialTicks), true));
        }
        Pair<ResourceLocation, FurnaceBoatModel> pair = this.getModelWithLocation(entityIn);
        ResourceLocation boatLocation = this.getTextureLocation(entityIn);
        BoatModel boatModel = (BoatModel)pair.getSecond();
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boatModel.m_6973_((Boat)entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(boatModel.m_103119_(boatLocation));
        boatModel.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entityIn.m_5842_()) {
            VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(RenderType.m_110478_());
            boatModel.m_102282_().m_104301_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.f_118083_);
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(FurnaceBoat boat) {
        Object name = ((ResourceLocation)this.getModelWithLocation(boat).getFirst()).toString();
        if (boat.getFuel() > 0) {
            name = (String)name + "_on";
        }
        return new ResourceLocation((String)name + ".png");
    }

    public Pair<ResourceLocation, FurnaceBoatModel> getModelWithLocation(FurnaceBoat boat) {
        return this.boatResources.get(boat.getBoatloadBoatType());
    }
}

