/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.common.entity.vehicle;

import com.teamabnormals.boatload.common.entity.vehicle.BoatloadBoat;
import com.teamabnormals.boatload.core.registry.BoatloadEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class FurnaceBoat
extends BoatloadBoat {
    public static final Ingredient FUEL_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_});
    private static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.m_135353_(FurnaceBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public FurnaceBoat(EntityType<? extends Boat> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public FurnaceBoat(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)BoatloadEntityTypes.FURNACE_BOAT.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public FurnaceBoat(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType<? extends Boat>)((EntityType)BoatloadEntityTypes.FURNACE_BOAT.get()), worldIn);
    }

    protected float m_213802_() {
        return 0.15f;
    }

    protected int m_213801_() {
        return 1;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUEL, (Object)0);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Fuel", this.getFuel());
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFuel(compound.m_128451_("Fuel"));
    }

    public void setFuel(@Nullable int fuel) {
        this.f_19804_.m_135381_(FUEL, (Object)fuel);
    }

    @Nullable
    public int getFuel() {
        return (Integer)this.f_19804_.m_135370_(FUEL);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (FUEL_ITEMS.test(itemstack) && this.getFuel() + 3600 <= 32000) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.setFuel(this.getFuel() + 3600);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getFuel() > 0) {
            this.setFuel(this.getFuel() - 1);
            float f = (this.m_146908_() - 90.0f) * ((float)Math.PI / 180);
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            if (this.f_19853_.f_46443_ && this.f_19796_.m_188503_(4) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)f1 * 0.5, this.m_20186_() + 1.0, this.m_20189_() + (double)f2 * 0.5, 0.0, 0.0, 0.0);
            }
            if (this.f_19796_.m_188503_(40) == 0) {
                this.f_19853_.m_7785_(this.m_20185_() + (double)f1 * 0.5, this.m_20186_(), this.m_20189_() + (double)f2 * 0.5, SoundEvents.f_11907_, this.m_5720_(), 1.0f, 1.0f, false);
            }
        }
    }

    protected void m_38396_() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.f_38273_) {
                this.f_38266_ -= 1.0f;
            }
            if (this.f_38274_) {
                this.f_38266_ += 1.0f;
            }
            if (this.f_38274_ != this.f_38273_ && !this.f_38275_ && !this.f_38276_) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.f_38266_);
            if (this.f_38275_) {
                f += 0.04f;
                if (this.getFuel() > 0) {
                    f += 0.026f;
                }
            }
            if (this.f_38276_) {
                f -= 0.005f;
                if (this.getFuel() > 0) {
                    f -= 0.01f;
                }
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f)));
            this.m_38339_(this.f_38274_ && !this.f_38273_ || this.f_38275_, this.f_38273_ && !this.f_38274_ || this.f_38275_);
            if (this.getFuel() > 0 && this.f_38279_ == Boat.Status.IN_WATER) {
                float f1 = (this.m_146908_() - 90.0f) * ((float)Math.PI / 180);
                float f2 = Mth.m_14089_((float)f1);
                float f3 = Mth.m_14031_((float)f1);
                for (int i = 0; i < 10; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f2 * 0.8 + (this.f_19796_.m_188500_() - 0.5), this.m_20186_() + (double)0.2f, this.m_20189_() + (double)f3 * 0.8 + (this.f_19796_.m_188500_() - 0.5), 0.0, 0.05, 0.0);
                }
            }
        }
    }

    @Override
    public Item m_38369_() {
        return this.getBoatloadBoatType().furnaceBoat().get();
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getBoatloadBoatType().furnaceBoat().get());
    }
}

