/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.common.item;

import com.teamabnormals.boatload.common.entity.vehicle.BoatloadBoat;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoatloadBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final BoatloadBoatType type;

    public BoatloadBoatItem(BoatloadBoatType typeIn) {
        this(typeIn, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40752_));
    }

    public BoatloadBoatItem(BoatloadBoatType typeIn, Item.Properties properties) {
        super(properties);
        this.type = typeIn;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new BoatloadBoatDispenseItemBehavior());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult raytraceresult = BoatloadBoatItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vector3d = playerIn.m_20252_(1.0f);
        List list = worldIn.m_6249_((Entity)playerIn, playerIn.m_20191_().m_82369_(vector3d.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vector3d1 = playerIn.m_20299_(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!axisalignedbb.m_82390_(vector3d1)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            BoatloadBoat boatentity = this.getBoatEntity(worldIn, (HitResult)raytraceresult, itemstack);
            boatentity.setBoatloadBoatType(this.type);
            boatentity.m_146922_(playerIn.m_146908_());
            if (!worldIn.m_45756_((Entity)boatentity, boatentity.m_20191_().m_82400_(-0.1))) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!worldIn.f_46443_) {
                worldIn.m_7967_((Entity)boatentity);
                if (!playerIn.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    protected BoatloadBoat getBoatEntity(Level level, HitResult result, ItemStack stack) {
        return this.getBoatEntity(level, result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, stack);
    }

    protected BoatloadBoat getBoatEntity(Level level, double x, double y, double z, ItemStack stack) {
        return null;
    }

    public BoatloadBoatType getType() {
        return this.type;
    }

    public static class BoatloadBoatDispenseItemBehavior
    extends DefaultDispenseItemBehavior {
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double adjustY;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = source.m_7727_();
            double x = source.m_7096_() + (double)((float)direction.m_122429_() * 1.125f);
            double y = source.m_7098_() + (double)((float)direction.m_122430_() * 1.125f);
            double z = source.m_7094_() + (double)((float)direction.m_122431_() * 1.125f);
            BlockPos pos = source.m_7961_().m_121945_(direction);
            if (level.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                adjustY = 1.0;
            } else {
                if (!level.m_8055_(pos).m_60795_() || !level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
                    return this.defaultDispenseItemBehavior.m_6115_(source, stack);
                }
                adjustY = 0.0;
            }
            BoatloadBoatItem item = (BoatloadBoatItem)stack.m_41720_();
            BoatloadBoat boat = item.getBoatEntity((Level)level, x, y + adjustY, z, stack);
            boat.setBoatloadBoatType(item.type);
            boat.m_146922_(direction.m_122435_());
            level.m_7967_((Entity)boat);
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
        }
    }
}

