/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.api;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.boatload.core.registry.BoatloadItems;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public record BoatloadBoatType(ResourceLocation registryName, Supplier<Item> planks, Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Item> furnaceBoat, Supplier<Item> largeBoat, boolean fireproof) {
    private static final Set<BoatloadBoatType> BOAT_TYPES = new ObjectArraySet();
    public static final BoatloadBoatType OAK = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "oak"), () -> Items.f_42647_, () -> Items.f_42453_, () -> Items.f_220207_, () -> (Item)BoatloadItems.OAK_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_OAK_BOAT.get()));
    public static final BoatloadBoatType BIRCH = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "birch"), () -> Items.f_42753_, () -> Items.f_42743_, () -> Items.f_220200_, () -> (Item)BoatloadItems.BIRCH_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_BIRCH_BOAT.get()));
    public static final BoatloadBoatType SPRUCE = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "spruce"), () -> Items.f_42700_, () -> Items.f_42742_, () -> Items.f_220208_, () -> (Item)BoatloadItems.SPRUCE_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_SPRUCE_BOAT.get()));
    public static final BoatloadBoatType JUNGLE = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "jungle"), () -> Items.f_42794_, () -> Items.f_42744_, () -> Items.f_220201_, () -> (Item)BoatloadItems.JUNGLE_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_JUNGLE_BOAT.get()));
    public static final BoatloadBoatType ACACIA = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "acacia"), () -> Items.f_42795_, () -> Items.f_42745_, () -> Items.f_220202_, () -> (Item)BoatloadItems.ACACIA_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_ACACIA_BOAT.get()));
    public static final BoatloadBoatType DARK_OAK = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "dark_oak"), () -> Items.f_42796_, () -> Items.f_42746_, () -> Items.f_220203_, () -> (Item)BoatloadItems.DARK_OAK_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_DARK_OAK_BOAT.get()));
    public static final BoatloadBoatType MANGROVE = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "mangrove"), () -> Items.f_220174_, () -> Items.f_220204_, () -> Items.f_220205_, () -> (Item)BoatloadItems.MANGROVE_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_MANGROVE_BOAT.get()));
    public static final BoatloadBoatType CRIMSON = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "crimson"), () -> Items.f_42797_, () -> (Item)BoatloadItems.CRIMSON_BOAT.get(), () -> (Item)BoatloadItems.CRIMSON_CHEST_BOAT.get(), () -> (Item)BoatloadItems.CRIMSON_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_CRIMSON_BOAT.get(), true));
    public static final BoatloadBoatType WARPED = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("boatload", "warped"), () -> Items.f_42798_, () -> (Item)BoatloadItems.WARPED_BOAT.get(), () -> (Item)BoatloadItems.WARPED_CHEST_BOAT.get(), () -> (Item)BoatloadItems.WARPED_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_WARPED_BOAT.get(), true));

    public static BoatloadBoatType create(ResourceLocation registryName, Supplier<Item> planks, Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Item> furnaceBoat, Supplier<Item> largeBoat, boolean fireproof) {
        return new BoatloadBoatType(registryName, planks, boat, chestBoat, furnaceBoat, largeBoat, fireproof);
    }

    public static BoatloadBoatType create(ResourceLocation registryName, Supplier<Item> planks, Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Item> furnaceBoat, Supplier<Item> largeBoat) {
        return BoatloadBoatType.create(registryName, planks, boat, chestBoat, furnaceBoat, largeBoat, false);
    }

    public static synchronized BoatloadBoatType register(BoatloadBoatType type) {
        BOAT_TYPES.add(type);
        return type;
    }

    public static ImmutableList<BoatloadBoatType> values() {
        return ImmutableList.copyOf(BOAT_TYPES);
    }

    public static BoatloadBoatType getTypeFromString(String name) {
        for (BoatloadBoatType type : BoatloadBoatType.values()) {
            if (!type.registryName().toString().equals(name)) continue;
            return type;
        }
        return OAK;
    }

    public static BoatloadBoatType getTypeFromBoat(Item boat) {
        for (BoatloadBoatType type : BoatloadBoatType.values()) {
            if (type.boat().get() != boat) continue;
            return type;
        }
        return OAK;
    }
}

