/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.data.client;

import com.teamabnormals.boatload.core.other.BoatloadUtil;
import com.teamabnormals.boatload.core.registry.BoatloadEntityTypes;
import com.teamabnormals.boatload.core.registry.BoatloadItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class BoatloadLanguageProvider
extends LanguageProvider {
    public BoatloadLanguageProvider(DataGenerator generator) {
        super(generator, "boatload", "en_us");
    }

    protected void addTranslations() {
        this.add((EntityType)BoatloadEntityTypes.FURNACE_BOAT.get(), "Boat with Furnace");
        this.add((EntityType)BoatloadEntityTypes.LARGE_BOAT.get(), "Large Boat");
        this.add((Item)BoatloadItems.CRIMSON_BOAT.get());
        this.add((Item)BoatloadItems.WARPED_BOAT.get());
        this.addChestBoat((Item)BoatloadItems.CRIMSON_CHEST_BOAT.get());
        this.addChestBoat((Item)BoatloadItems.WARPED_CHEST_BOAT.get());
        BoatloadUtil.getFurnaceBoats().forEach(this::addFurnaceBoat);
        BoatloadUtil.getLargeBoats().forEach(this::add);
    }

    private void add(Item item) {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item);
        if (name != null) {
            this.add(item, this.format(name));
        }
    }

    private void addChestBoat(Item item) {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item);
        if (name != null) {
            this.add(item, this.format(name).replace("Chest Boat", "Boat with Chest"));
        }
    }

    private void addFurnaceBoat(Item item) {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item);
        if (name != null) {
            this.add(item, this.format(name).replace("Furnace Boat", "Boat with Furnace"));
        }
    }

    private String format(ResourceLocation registryName) {
        return WordUtils.capitalizeFully((String)registryName.m_135815_().replace("_", " "));
    }
}

