/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.other;

import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.common.entity.BlueprintBoat;
import com.teamabnormals.blueprint.common.entity.BlueprintChestBoat;
import com.teamabnormals.blueprint.core.registry.BoatTypeRegistry;
import com.teamabnormals.boatload.common.entity.vehicle.BoatloadBoat;
import com.teamabnormals.boatload.common.item.FurnaceBoatItem;
import com.teamabnormals.boatload.common.item.LargeBoatItem;
import com.teamabnormals.boatload.core.Boatload;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;

public class BoatloadUtil {
    public static List<Item> getItems() {
        ArrayList items = Lists.newArrayList();
        Boatload.REGISTRY_HELPER.getItemSubHelper().getDeferredRegister().getEntries().forEach(registryObject -> items.add((Item)registryObject.get()));
        return items;
    }

    public static List<FurnaceBoatItem> getFurnaceBoats() {
        return BoatloadUtil.getItems().stream().filter(item -> item instanceof FurnaceBoatItem).collect(Collectors.toList());
    }

    public static List<LargeBoatItem> getLargeBoats() {
        return BoatloadUtil.getItems().stream().filter(item -> item instanceof LargeBoatItem).collect(Collectors.toList());
    }

    public static boolean isNetherBoat(Entity entity) {
        if (entity instanceof BoatloadBoat) {
            BoatloadBoat boat = (BoatloadBoat)entity;
            return boat.getBoatloadBoatType().fireproof();
        }
        BoatTypeRegistry.BoatTypeData typeData = null;
        if (entity instanceof BlueprintBoat) {
            BlueprintBoat boat = (BlueprintBoat)entity;
            typeData = boat.getBoatTypeData();
        } else if (entity instanceof BlueprintChestBoat) {
            BlueprintChestBoat boat = (BlueprintChestBoat)entity;
            typeData = boat.getBoatTypeData();
        }
        return typeData != null && BoatloadBoatType.getTypeFromString(BoatTypeRegistry.getNameForData((BoatTypeRegistry.BoatTypeData)typeData)).fireproof();
    }
}

