/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.registry.helper;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.item.BlueprintBoatItem;
import com.teamabnormals.blueprint.core.registry.BoatTypeRegistry;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.boatload.common.item.FurnaceBoatItem;
import com.teamabnormals.boatload.common.item.LargeBoatItem;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class BoatloadItemSubRegistryHelper
extends ItemSubRegistryHelper {
    public BoatloadItemSubRegistryHelper(RegistryHelper parent) {
        super(parent, parent.getItemSubHelper().getDeferredRegister());
    }

    public Pair<RegistryObject<Item>, RegistryObject<Item>> createBoatAndChestBoatItem(String wood, Block block) {
        String type = this.parent.getModId() + ":" + wood;
        RegistryObject boat = this.deferredRegister.register(wood + "_boat", () -> new BlueprintBoatItem(false, type, BoatloadItemSubRegistryHelper.createSimpleItemProperty((int)1, (CreativeModeTab)CreativeModeTab.f_40752_)));
        RegistryObject chestBoat = this.deferredRegister.register(wood + "_chest_boat", () -> new BlueprintBoatItem(true, type, BoatloadItemSubRegistryHelper.createSimpleItemProperty((int)1, (CreativeModeTab)CreativeModeTab.f_40752_)));
        BoatTypeRegistry.registerBoat((String)type, (Supplier)boat, (Supplier)chestBoat, () -> block);
        return Pair.of((Object)boat, (Object)chestBoat);
    }

    public RegistryObject<Item> createFurnaceBoat(BoatloadBoatType type) {
        return this.deferredRegister.register(type.registryName().m_135815_() + "_furnace_boat", () -> new FurnaceBoatItem(type));
    }

    public RegistryObject<Item> createLargeBoat(BoatloadBoatType type) {
        return this.deferredRegister.register("large_" + type.registryName().m_135815_() + "_boat", () -> new LargeBoatItem(type));
    }
}

