/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight;

import com.sammy.minersdelight.data.MDLangMerger;
import com.sammy.minersdelight.data.MDRecipeProvider;
import com.sammy.minersdelight.repack.registrate.Registrate;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullSupplier;
import com.sammy.minersdelight.setup.MDBlockEntities;
import com.sammy.minersdelight.setup.MDBlocks;
import com.sammy.minersdelight.setup.MDCauldronInteractions;
import com.sammy.minersdelight.setup.MDItems;
import com.sammy.minersdelight.setup.MDLootConditions;
import com.sammy.minersdelight.setup.MDLootModifiers;
import com.sammy.minersdelight.setup.MDMenuTypes;
import com.sammy.minersdelight.setup.MDWorldgen;
import java.util.Random;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="miners_delight")
public class MinersDelightMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "miners_delight";
    public static final Random RANDOM = new Random();
    public static final NonNullSupplier<Registrate> REGISTRATE = NonNullSupplier.lazy(() -> Registrate.create(MODID));

    public static Registrate registrate() {
        return REGISTRATE.get();
    }

    public MinersDelightMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        MDLootModifiers.LOOT_MODIFIERS.register(modBus);
        MDLootConditions.LOOT_CONDITIONS.register(modBus);
        MDMenuTypes.MENU_TYPES.register(modBus);
        MDBlocks.register();
        MDItems.register();
        MDBlockEntities.register();
        modBus.addListener(MDCauldronInteractions::addCauldronInteractions);
        modBus.addListener(MDWorldgen::addWorldgen);
        modBus.addListener(DataOnly::gatherData);
    }

    public static ResourceLocation path(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static class DataOnly {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            generator.m_236039_(true, (DataProvider)new MDLangMerger(generator));
            generator.m_236039_(true, (DataProvider)new MDRecipeProvider(generator));
        }
    }
}

