/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DoltModHowConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> doMetalOresDropXP;
        public final ForgeConfigSpec.ConfigValue<Boolean> doCropBlocksDropXP;
        public final ForgeConfigSpec.ConfigValue<Integer> minCropXpDrops;
        public final ForgeConfigSpec.ConfigValue<Integer> maxCropXpDrops;
        public final ForgeConfigSpec.ConfigValue<Boolean> doDistanceBasedWandererBootSpawning;
        public final ForgeConfigSpec.ConfigValue<Boolean> doRichSoilGrowFungusColony;
        public final ForgeConfigSpec.ConfigValue<Boolean> doHackyQuiverRecipe;
        public final ForgeConfigSpec.ConfigValue<Boolean> doUnbloatKnifeEnchants;
        public final ForgeConfigSpec.ConfigValue<Boolean> doDispenserCauldrons;
        public final ForgeConfigSpec.ConfigValue<Boolean> doLightningEpilogueDisc;
        public final ForgeConfigSpec.ConfigValue<Boolean> doUntillableFarmland;
        public final ForgeConfigSpec.ConfigValue<Boolean> removeOrangeVapor;
        public final ForgeConfigSpec.ConfigValue<Boolean> overhaulTipsyOverlay;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("Vanilla");
            builder.push("metal_ores");
            this.doMetalOresDropXP = builder.comment("If mining ores that normally drop raw ores should grant XP").define("Experienced metal", true);
            builder.pop();
            builder.push("farmland");
            this.doUntillableFarmland = builder.comment("Whether farmland can be untilled by sneak-right clicking them with a hoe").define("Untillable Farmland", true);
            builder.pop();
            builder.push("crops");
            this.doCropBlocksDropXP = builder.comment("If all blocks that are crops should drop experience.").define("Experienced Crops", true);
            this.minCropXpDrops = builder.comment("Minimum XP a crop block will drop when broken.").define("Minimum Crop XP", (Object)0);
            this.maxCropXpDrops = builder.comment("Maximum XP a crop block will drop when broken.").define("Maximum Crop XP", (Object)1);
            builder.pop();
            builder.push("dispensers");
            this.doDispenserCauldrons = builder.comment("If dispensers should be able to dispense into cauldrons").define("Dispenser Cauldrons", true);
            builder.pop();
            builder.pop();
            builder.push("atmospheric");
            builder.push("Oranges");
            this.removeOrangeVapor = builder.comment("If oranges can no longer be jumped on to be broken and to create a vapor cloud").define("Normal Oranges", true);
            builder.pop();
            builder.pop();
            builder.push("farmersdelight");
            builder.push("Knife Enchantments");
            this.doUnbloatKnifeEnchants = builder.comment("If knives should no longer receive the silk touch and efficiency from the enchanting table").define("Unbloated Knife Enchantments", true);
            builder.pop();
            builder.pop();
            builder.push("brewin_and_chewin");
            builder.push("Tipsy");
            this.overhaulTipsyOverlay = builder.comment("If the tipsy effect should, instead of doing whatever it does now, should act as a progressively worsening nausea effect. TO FULLY DISABLE THIS FEATURE, PLEASE ALSO TURN OFF \"WEIRD TIPSY\" IN THE COMMON CONFIG").define("Weird Tipsy", true);
            builder.pop();
            builder.pop();
            builder.push("nethersdelight");
            builder.push("fungus_colonies");
            this.doRichSoilGrowFungusColony = builder.comment("If fungus colonies should grow on normal rich soil instead of soul rich soil").define("Rich Fungus", true);
            builder.pop();
            builder.pop();
            builder.push("environmental");
            builder.push("wanderers_boots");
            this.doDistanceBasedWandererBootSpawning = builder.comment("If mobs will spawn with wanderer's boots with some odds proportional to how far they are away from the 0, 0").define("Cool Boots", true);
            builder.pop();
            builder.pop();
            builder.push("supplementaries");
            builder.push("quivers");
            this.doHackyQuiverRecipe = builder.comment("If processing a quiver in a cutting board will eject all the arrows in that quiver").define("Realistic Quivers", true);
            builder.pop();
            builder.pop();
            builder.push("anchor");
            builder.push("epilogue Disc");
            this.doLightningEpilogueDisc = builder.comment("If striking a jukebox with lightning with a filled disc inside will change that disc to Epilogue").define("AWESOME epilogue disc", true);
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> removeSullyGrindstoneTooltip;
        public final ForgeConfigSpec.ConfigValue<Boolean> overhaulTipsyOverlay;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("Sully's Mod");
            builder.push("Grindstone Tooltip");
            this.removeSullyGrindstoneTooltip = builder.comment("If the tooltips appended to grindable items in Sully's Mod should be removed").define("No Grindstone Tooltip", true);
            builder.pop();
            builder.pop();
            builder.push("Brewin' and Chewin'");
            builder.push("Tipsy");
            this.overhaulTipsyOverlay = builder.comment("If the tipsy effect should, instead of doing whatever it does now, should act as a progressively worsening nausea effect. TO FULLY DISABLE THIS FEATURE, PLEASE ALSO TURN OFF \"WEIRD TIPSY\" IN THE COMMON CONFIG").define("Weird Tipsy", true);
            builder.pop();
            builder.pop();
        }
    }
}

