/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core.mixin.environmental;

import com.dolthhaven.dolt_mod_how.core.DoltModHowConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobEntityMixin
extends LivingEntity {
    @Shadow
    @Final
    protected float[] f_21348_;

    protected MobEntityMixin(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"populateDefaultEquipmentSlots(Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/DifficultyInstance;)V"}, at={@At(value="TAIL")})
    private void DoltModHow$ChanceForWanderingBootsSpawn(RandomSource random, DifficultyInstance difficulty, CallbackInfo info) {
        if (ModList.get().isLoaded("environmental") && ((Boolean)DoltModHowConfig.COMMON.doDistanceBasedWandererBootSpawning.get()).booleanValue()) {
            double chance = MobEntityMixin.dubs(this.m_20182_().m_82554_(new Vec3(0.0, 0.0, 0.0)));
            Item boots = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("environmental", "wanderer_boots"));
            if (random.m_188500_() < chance && boots != null) {
                this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)boots));
                this.f_21348_[EquipmentSlot.FEET.m_20749_()] = 1.0f;
            }
        }
    }

    @Unique
    private static double dubs(double distance) {
        return MobEntityMixin.cubeRoot(distance / 4500.0) / 30.0 + Math.exp(-MobEntityMixin.square((distance - 24000.0) / 8000.0)) / 20.0 / 2.0;
    }

    @Unique
    private static double square(double thing) {
        return thing * thing;
    }

    @Unique
    private static double cubeRoot(double thing) {
        return Math.pow(thing, 0.3333);
    }
}

