/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core.other;

import com.dolthhaven.dolt_mod_how.core.DoltModHowConfig;
import com.dolthhaven.dolt_mod_how.core.data.tag.CompatTags;
import com.dolthhaven.dolt_mod_how.core.registry.DMHEnchants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.registry.ModBlocks;

@Mod.EventBusSubscriber(modid="dolt_mod_how")
public class DoltModHowEvent {
    private static final UniformInt COMMON_ORE = UniformInt.m_146622_((int)0, (int)2);
    private static final UniformInt RARE_ORE = UniformInt.m_146622_((int)1, (int)3);

    @SubscribeEvent
    public static void projectileImpact(ProjectileImpactEvent event) {
        HitResult hitResult;
        ThrownTrident trident;
        Projectile projectile = event.getProjectile();
        if (projectile instanceof ThrownTrident && (trident = (ThrownTrident)projectile).m_150194_() && (hitResult = event.getRayTraceResult()) instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)hitResult;
            Level level = trident.m_9236_();
            if (!level.m_46470_()) {
                return;
            }
            BlockPos pos = result.m_82425_();
            if (!level.m_45527_(pos.m_7494_())) {
                return;
            }
            if (level.m_8055_(pos).m_204336_(CompatTags.CHANNELS_LIGHTNING)) {
                ServerPlayer player;
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                if (bolt == null) {
                    return;
                }
                bolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_7494_()));
                Entity entity = event.getProjectile().m_37282_();
                bolt.m_20879_(entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null);
                level.m_7967_((Entity)bolt);
                level.m_5594_(null, pos, SoundEvents.f_12521_, SoundSource.WEATHER, 5.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)DoltModHowConfig.COMMON.doUntillableFarmland.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        if (stack.m_41720_() instanceof HoeItem && player.m_6047_()) {
            if (level.m_8055_(pos).m_60713_(Blocks.f_50093_)) {
                stack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21166_(LivingEntity.m_147233_((ItemStack)stack)));
                level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
                player.m_6674_(event.getHand());
                level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (level.m_8055_(pos).m_60713_((Block)ModBlocks.RICH_SOIL_FARMLAND.get())) {
                stack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21166_(LivingEntity.m_147233_((ItemStack)stack)));
                level.m_7731_(pos, ((Block)ModBlocks.RICH_SOIL.get()).m_49966_(), 2);
                player.m_6674_(event.getHand());
                level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDropEvent(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            event.getDrops().stream().map(ItemEntity::m_32055_).filter(i -> i.getEnchantmentLevel((Enchantment)DMHEnchants.BOUNDING.get()) > 0).forEach(i -> player.m_150109_().m_36054_(i));
        }
    }

    @SubscribeEvent
    public static void onPlayerCloneEvent(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player nw = event.getEntity();
            Player old = event.getOriginal();
            NonNullList items = old.m_150109_().f_35974_;
            for (ItemStack stackie : items.stream().filter(i -> i.getEnchantmentLevel((Enchantment)DMHEnchants.BOUNDING.get()) >= 1).toList()) {
                if (nw.m_150109_().m_36054_(stackie)) continue;
                nw.m_36176_(stackie, false);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakOreEvent(BlockEvent.BreakEvent event) {
        if (!((Boolean)DoltModHowConfig.COMMON.doMetalOresDropXP.get()).booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockState state = event.getState();
            if (!event.getPlayer().m_36298_(state)) {
                return;
            }
            if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)event.getPlayer()) > 0) {
                return;
            }
            if (state.m_204336_(CompatTags.COMMON_ORES)) {
                int exp = COMMON_ORE.m_214085_(level.m_213780_());
                event.setExpToDrop(exp);
            } else if (state.m_204336_(CompatTags.RARE_ORES)) {
                event.setExpToDrop(RARE_ORE.m_214085_(level.m_213780_()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakCropsEvent(BlockEvent.BreakEvent event) {
        if (!((Boolean)DoltModHowConfig.COMMON.doCropBlocksDropXP.get()).booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockState state = event.getState();
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                if (!state.m_204336_(CompatTags.NO_XP_CROPS) && cropBlock.m_52307_(state)) {
                    UniformInt crop_sampler = UniformInt.m_146622_((int)((Integer)DoltModHowConfig.COMMON.minCropXpDrops.get()), (int)((Integer)DoltModHowConfig.COMMON.maxCropXpDrops.get()));
                    event.setExpToDrop(crop_sampler.m_214085_(level.m_213780_()));
                }
            }
        }
    }
}

