/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.common.block;

import com.teamabnormals.autumnity.common.block.TallFoulBerryBushBlock;
import com.teamabnormals.autumnity.common.entity.animal.Snail;
import com.teamabnormals.autumnity.common.entity.animal.Turkey;
import com.teamabnormals.autumnity.core.AutumnityConfig;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityEntityTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class FoulBerryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};

    public FoulBerryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((Boolean)AutumnityConfig.COMMON.foulBerriesRequirePips.get() != false ? (ItemLike)AutumnityItems.FOUL_BERRY_PIPS.get() : (ItemLike)AutumnityItems.FOUL_BERRIES.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)AGE)];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if ((Integer)stateIn.m_61143_((Property)AGE) == 1 && rand.m_188503_(5) == 0) {
            VoxelShape voxelshape = this.m_5940_(stateIn, (BlockGetter)worldIn, pos, CollisionContext.m_82749_());
            Vec3 vector3d = voxelshape.m_83215_().m_82399_();
            double d0 = (double)pos.m_123341_() + vector3d.f_82479_;
            double d1 = (double)pos.m_123343_() + vector3d.f_82481_;
            int i = MobEffects.f_19614_.m_19484_();
            double d2 = (double)(i >> 16 & 0xFF) / 255.0;
            double d3 = (double)(i >> 8 & 0xFF) / 255.0;
            double d4 = (double)(i >> 0 & 0xFF) / 255.0;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123811_, d0 + (double)(rand.m_188501_() / 5.0f), (double)pos.m_123342_() + (0.5 - (double)rand.m_188501_()), d1 + (double)(rand.m_188501_() / 5.0f), d2, d3, d4);
        }
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (worldIn.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_(4) == 0 ? 1 : 0) != 0)) {
            if ((Integer)state.m_61143_((Property)AGE) == 0) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            } else if (worldIn.m_46859_(pos.m_7494_())) {
                TallFoulBerryBushBlock tallfoulberrybush = (TallFoulBerryBushBlock)((Object)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get());
                tallfoulberrybush.placeAt((LevelAccessor)worldIn, pos, 0, 2);
            }
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn;
            if (entityIn.m_6095_() != EntityType.f_20550_ && entityIn.m_6095_() != AutumnityEntityTypes.SNAIL.get() && entityIn.m_6095_() != AutumnityEntityTypes.TURKEY.get()) {
                entityIn.m_7601_(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
                if (!(worldIn.f_46443_ || livingentity.m_21023_(MobEffects.f_19614_) || livingentity.m_6144_())) {
                    livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60));
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)AGE) == 0) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
        } else if (worldIn.m_46859_(pos.m_7494_())) {
            TallFoulBerryBushBlock tallfoulberrybush = (TallFoulBerryBushBlock)((Object)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get());
            tallfoulberrybush.placeAt((LevelAccessor)worldIn, pos, 0, 2);
        }
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        if (!(entity instanceof Snail) && !(entity instanceof Turkey)) {
            return BlockPathTypes.DAMAGE_OTHER;
        }
        return super.getBlockPathType(state, world, pos, entity);
    }
}

