/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.common.block;

import com.teamabnormals.autumnity.common.entity.animal.Snail;
import com.teamabnormals.autumnity.core.other.tags.AutumnityBlockTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class SnailGooFullBlock
extends HalfTransparentBlock {
    public static final BooleanProperty SLIPPERY = BooleanProperty.m_61465_((String)"slippery");
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public SnailGooFullBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SLIPPERY, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SLIPPERY) == false ? SHAPE : super.m_5939_(state, worldIn, pos, context);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)SLIPPERY, (Comparable)Boolean.valueOf(this.shouldBeSlippery(context.m_8083_(), (BlockGetter)context.m_43725_())));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.m_61124_((Property)SLIPPERY, (Comparable)Boolean.valueOf(this.shouldBeSlippery(currentPos, (BlockGetter)worldIn)));
    }

    public final boolean shouldBeSlippery(BlockPos blockPos, BlockGetter iBlockReader) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos1 = blockPos.m_121945_(direction);
            if (!this.doesBlockMakeSlippery(blockpos1, iBlockReader.m_8055_(blockpos1), iBlockReader)) continue;
            return true;
        }
        return false;
    }

    public final boolean doesBlockMakeSlippery(BlockPos blockPos, BlockState state, BlockGetter iBlockReader) {
        FluidState fluidstate = iBlockReader.m_6425_(blockPos);
        return state.m_204336_(AutumnityBlockTags.SLIPPERY_SNAIL_GOO_BLOCKS) || fluidstate.m_205070_(FluidTags.f_13131_);
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.m_6144_()) {
            super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
        } else {
            entityIn.m_142535_(fallDistance, 0.0f, DamageSource.f_19315_);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!((Boolean)state.m_61143_((Property)SLIPPERY)).booleanValue() && !(entityIn instanceof Snail)) {
            if (entityIn.m_20191_().f_82292_ <= (double)pos.m_123342_() + 0.0625) {
                if (!entityIn.m_6144_()) {
                    entityIn.m_7601_(state, new Vec3(1.0, 0.0, 1.0));
                }
            } else {
                entityIn.m_20256_(entityIn.m_20184_().m_82542_(0.4, 1.0, 0.4));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SLIPPERY});
    }

    public float getFriction(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return (Boolean)state.m_61143_((Property)SLIPPERY) != false ? 0.98f : 0.6f;
    }

    public boolean isStickyBlock(BlockState state) {
        return (Boolean)state.m_61143_((Property)SLIPPERY) == false;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        if (other.m_60734_() == Blocks.f_50374_) {
            return false;
        }
        if (other.m_60734_() == Blocks.f_50719_) {
            return false;
        }
        if (other.m_60734_() == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("upgrade_aquatic", "mulberry_jam_block"))) {
            return false;
        }
        if (other.m_60734_() == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atmospheric", "aloe_gel_block"))) {
            return false;
        }
        return super.canStickTo(state, other);
    }
}

