/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.common.entity.animal;

import com.teamabnormals.autumnity.core.other.tags.AutumnityItemTags;
import com.teamabnormals.autumnity.core.registry.AutumnityEntityTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import com.teamabnormals.autumnity.core.registry.AutumnitySoundEvents;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Turkey
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(Turkey.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float wingRotation;
    private float destPos;
    private float oFlapSpeed;
    private float oFlap;
    private float wingRotDelta = 1.0f;
    private float peckTicks;
    private float prevPeckTicks;
    public int timeUntilNextEgg = this.f_19796_.m_188503_(9600) + 9600;
    public boolean turkeyJockey;
    private static final UniformInt ANGER_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private UUID lastHurtBy;

    public Turkey(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(AutumnityItemTags.TURKEY_FOOD), false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Turkey)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, new JockeyTargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.85f : sizeIn.f_20378_ * 0.92f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.peckTicks = 8.0f;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        this.peckTicks = 8.0f;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        return super.m_7327_(entityIn);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            this.oFlap = this.wingRotation;
            this.oFlapSpeed = this.destPos;
            this.destPos = (float)((double)this.destPos + (double)(this.f_19861_ ? -1 : 4) * 0.3);
            this.destPos = Mth.m_14036_((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.f_19861_ && this.wingRotDelta < 1.0f) {
                this.wingRotDelta = 1.0f;
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            this.wingRotation += this.wingRotDelta * 2.0f;
        }
        this.prevPeckTicks = this.peckTicks;
        if (this.peckTicks > 0.0f) {
            this.peckTicks -= 1.0f;
        }
        Vec3 vector3d = this.m_20184_();
        if (!this.f_19861_ && vector3d.f_82480_ < 0.0) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_6084_() && !this.m_6162_() && !this.isTurkeyJockey() && --this.timeUntilNextEgg <= 0) {
                this.m_5496_((SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_EGG.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19998_((ItemLike)AutumnityItems.TURKEY_EGG.get());
                this.timeUntilNextEgg = this.getRandomNextEggTime(this.f_19796_);
            }
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getWingRotation(float partialTicks) {
        float f = Mth.m_14179_((float)partialTicks, (float)this.oFlap, (float)this.wingRotation);
        float f1 = Mth.m_14179_((float)partialTicks, (float)this.oFlapSpeed, (float)this.destPos);
        return (Mth.m_14031_((float)f) + 1.0f) * f1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getPeckProgress(float partialTicks) {
        float f = Mth.m_14179_((float)partialTicks, (float)this.prevPeckTicks, (float)this.peckTicks) / 8.0f;
        if (f < 0.5f) {
            return 2.0f * f;
        }
        return -2.0f * f + 2.0f;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.m_21660_() ? (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_AGGRO.get() : (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_204132_(AutumnityItemTags.TURKEY_FOOD).test(stack);
    }

    public int m_213860_() {
        return this.isTurkeyJockey() ? 10 : super.m_213860_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.turkeyJockey = compound.m_128471_("IsTurkeyJockey");
        if (compound.m_128441_("EggLayTime")) {
            this.timeUntilNextEgg = compound.m_128451_("EggLayTime");
        }
        this.m_147285_(this.f_19853_, compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsTurkeyJockey", this.turkeyJockey);
        compound.m_128405_("EggLayTime", this.timeUntilNextEgg);
        this.m_21678_(compound);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.isTurkeyJockey();
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        passenger.m_6034_(this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.5) + passenger.m_6049_() + 0.0, this.m_20189_() - (double)(0.1f * f1));
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).f_20883_ = this.f_20883_;
        }
    }

    public boolean isTurkeyJockey() {
        return this.turkeyJockey;
    }

    public void setTurkeyJockey(boolean jockey) {
        this.turkeyJockey = jockey;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)AutumnityEntityTypes.TURKEY.get()).m_20615_((Level)world);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)AutumnityItems.TURKEY_SPAWN_EGG.get());
    }

    public UUID m_6120_() {
        return this.lastHurtBy;
    }

    public void m_6925_(UUID target) {
        this.lastHurtBy = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_RANGE.m_214085_(this.f_19796_));
    }

    public int getRandomNextEggTime(RandomSource rand) {
        return rand.m_188503_(9600) + 9600;
    }

    static class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        public PanicGoal(Turkey turkey) {
            super((PathfinderMob)turkey, 1.4);
        }

        public boolean m_8036_() {
            return this.f_25684_.m_6162_() && super.m_8036_();
        }
    }

    static class HurtByTargetGoal
    extends net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal {
        public HurtByTargetGoal(Turkey turkey) {
            super((PathfinderMob)turkey, new Class[0]);
        }

        protected void m_5766_(Mob mobIn, LivingEntity targetIn) {
            if (mobIn instanceof Turkey && !mobIn.m_6162_()) {
                super.m_5766_(mobIn, targetIn);
            }
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.f_26135_.m_6162_()) {
                this.m_26047_();
                this.m_8041_();
            }
        }
    }

    static class JockeyTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public JockeyTargetGoal(Turkey turkey, Class<T> classTarget) {
            super((Mob)turkey, classTarget, true);
        }

        public boolean m_8036_() {
            Turkey turkey = (Turkey)this.f_26135_;
            return turkey.isTurkeyJockey() && super.m_8036_();
        }
    }
}

