/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core;

import com.teamabnormals.autumnity.client.model.SnailModel;
import com.teamabnormals.autumnity.client.model.TurkeyModel;
import com.teamabnormals.autumnity.client.renderer.entity.SnailRenderer;
import com.teamabnormals.autumnity.client.renderer.entity.TurkeyEggRenderer;
import com.teamabnormals.autumnity.client.renderer.entity.TurkeyRenderer;
import com.teamabnormals.autumnity.core.AutumnityConfig;
import com.teamabnormals.autumnity.core.data.client.AutumnityBlockStateProvider;
import com.teamabnormals.autumnity.core.data.client.AutumnityItemModelProvider;
import com.teamabnormals.autumnity.core.data.server.AutumnityAdvancementProvider;
import com.teamabnormals.autumnity.core.data.server.AutumnityLootTableProvider;
import com.teamabnormals.autumnity.core.data.server.AutumnityRecipeProvider;
import com.teamabnormals.autumnity.core.data.server.modifiers.AutumnityAdvancementModifierProvider;
import com.teamabnormals.autumnity.core.data.server.modifiers.AutumnityBiomeModifierProvider;
import com.teamabnormals.autumnity.core.data.server.modifiers.AutumnityModdedBiomeSliceProvider;
import com.teamabnormals.autumnity.core.data.server.tags.AutumnityBannerPatternTagsProvider;
import com.teamabnormals.autumnity.core.data.server.tags.AutumnityBiomeTagsProvider;
import com.teamabnormals.autumnity.core.data.server.tags.AutumnityBlockTagsProvider;
import com.teamabnormals.autumnity.core.data.server.tags.AutumnityEntityTypeTagsProvider;
import com.teamabnormals.autumnity.core.data.server.tags.AutumnityItemTagsProvider;
import com.teamabnormals.autumnity.core.data.server.tags.AutumnityPaintingVariantTagsProvider;
import com.teamabnormals.autumnity.core.data.server.tags.AutumnityStructureTagsProvider;
import com.teamabnormals.autumnity.core.other.AutumnityClientCompat;
import com.teamabnormals.autumnity.core.other.AutumnityCompat;
import com.teamabnormals.autumnity.core.other.AutumnityModelLayers;
import com.teamabnormals.autumnity.core.registry.AutumnityBannerPatterns;
import com.teamabnormals.autumnity.core.registry.AutumnityEntityTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityFeatures;
import com.teamabnormals.autumnity.core.registry.AutumnityLootConditions;
import com.teamabnormals.autumnity.core.registry.AutumnityMobEffects;
import com.teamabnormals.autumnity.core.registry.AutumnityNoiseParameters;
import com.teamabnormals.autumnity.core.registry.AutumnityPaintings;
import com.teamabnormals.autumnity.core.registry.AutumnityParticleTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityPlacementModifierTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityPotions;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="autumnity")
public class Autumnity {
    public static final String MOD_ID = "autumnity";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("autumnity");

    public Autumnity() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        AutumnityPaintings.PAINTINGS.register(bus);
        AutumnityMobEffects.MOB_EFFECTS.register(bus);
        AutumnityPotions.POTIONS.register(bus);
        AutumnityNoiseParameters.NOISE_PARAMETERS.register(bus);
        AutumnityPlacementModifierTypes.PLACEMENT_MODIFIER_TYPES.register(bus);
        AutumnityFeatures.FEATURES.register(bus);
        AutumnityFeatures.AutumnityConfiguredFeatures.CONFIGURED_FEATURES.register(bus);
        AutumnityFeatures.AutumnityPlacedFeatures.PLACED_FEATURES.register(bus);
        AutumnityParticleTypes.PARTICLE_TYPES.register(bus);
        AutumnityLootConditions.LOOT_CONDITION_TYPES.register(bus);
        AutumnityBannerPatterns.BANNER_PATTERNS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AutumnityConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AutumnityCompat.registerCompat();
            AutumnityPotions.registerBrewingRecipes();
            AutumnityEntityTypes.registerSpawns();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            AutumnityClientCompat.registerRenderLayers();
            AutumnityClientCompat.registerBlockColors();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        AutumnityBlockTagsProvider blockTags = new AutumnityBlockTagsProvider(generator, existingFileHelper);
        generator.m_236039_(includeServer, (DataProvider)blockTags);
        generator.m_236039_(includeServer, (DataProvider)new AutumnityItemTagsProvider(generator, blockTags, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityBiomeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityBannerPatternTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityPaintingVariantTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityStructureTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityEntityTypeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityRecipeProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityAdvancementProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityLootTableProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityAdvancementModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AutumnityModdedBiomeSliceProvider(generator));
        generator.m_236039_(includeServer, AutumnityBiomeModifierProvider.create(generator, existingFileHelper));
        boolean includeClient = event.includeClient();
        generator.m_236039_(includeClient, (DataProvider)new AutumnityItemModelProvider(generator, existingFileHelper));
        generator.m_236039_(includeClient, (DataProvider)new AutumnityBlockStateProvider(generator, existingFileHelper));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(AutumnityModelLayers.SNAIL, SnailModel::createBodyLayer);
        event.registerLayerDefinition(AutumnityModelLayers.TURKEY, TurkeyModel::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AutumnityEntityTypes.SNAIL.get(), SnailRenderer::new);
        event.registerEntityRenderer((EntityType)AutumnityEntityTypes.TURKEY.get(), TurkeyRenderer::new);
        event.registerEntityRenderer((EntityType)AutumnityEntityTypes.TURKEY_EGG.get(), TurkeyEggRenderer::new);
    }
}

