/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core.data.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.autumnity.common.block.PancakeBlock;
import com.teamabnormals.autumnity.common.block.TallFoulBerryBushBlock;
import com.teamabnormals.autumnity.common.block.TurkeyBlock;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityEntityTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import com.teamabnormals.blueprint.common.block.VerticalSlabBlock;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AutumnityLootTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(AutumnityBlockLoot::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(AutumnityEntityLoot::new, (Object)LootContextParamSets.f_81415_), (Object)Pair.of(AutumnityChestLoot::new, (Object)LootContextParamSets.f_81411_));

    public AutumnityLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    public List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    private static class AutumnityChestLoot
    extends ChestLoot {
        private AutumnityChestLoot() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(new ResourceLocation("autumnity", "chests/maple_hut"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AutumnityBlocks.SNAIL_GOO.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42590_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AutumnityItems.FOUL_BERRIES.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42501_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42405_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42591_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42046_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AutumnityItems.SAP_BOTTLE.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))))));
        }
    }

    private static class AutumnityEntityLoot
    extends EntityLoot {
        private AutumnityEntityLoot() {
        }

        public void addTables() {
            this.m_124371_((EntityType)AutumnityEntityTypes.SNAIL.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AutumnityBlocks.SNAIL_GOO.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)AutumnityEntityTypes.TURKEY.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AutumnityBlocks.TURKEY.get())).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        public Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(entity -> ForgeRegistries.ENTITY_TYPES.getKey(entity).m_135827_().equals("autumnity")).collect(Collectors.toSet());
        }
    }

    private static class AutumnityBlockLoot
    extends BlockLoot {
        private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        private AutumnityBlockLoot() {
        }

        public void addTables() {
            this.m_124288_((Block)AutumnityBlocks.SNAIL_GOO.get());
            this.m_124288_((Block)AutumnityBlocks.SNAIL_GOO_BLOCK.get());
            this.m_124175_((Block)AutumnityBlocks.PANCAKE.get(), AutumnityBlockLoot::createPancakeDrops);
            this.m_124288_((Block)AutumnityBlocks.AUTUMN_CROCUS.get());
            this.m_124252_((Block)AutumnityBlocks.POTTED_AUTUMN_CROCUS.get());
            this.m_124165_((Block)AutumnityBlocks.TURKEY.get(), AutumnityBlockLoot.createTurkeyDrops((Block)AutumnityBlocks.TURKEY.get(), (Item)AutumnityItems.TURKEY_PIECE.get()));
            this.m_124165_((Block)AutumnityBlocks.COOKED_TURKEY.get(), AutumnityBlockLoot.createTurkeyDrops((Block)AutumnityBlocks.COOKED_TURKEY.get(), (Item)AutumnityItems.COOKED_TURKEY_PIECE.get()));
            this.m_124288_((Block)AutumnityBlocks.TURKEY_EGG_CRATE.get());
            this.m_124165_((Block)AutumnityBlocks.FOUL_BERRY_BUSH.get(), AutumnityBlockLoot.m_124125_());
            this.m_124175_((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get(), block -> (LootTable.Builder)AutumnityBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)TallFoulBerryBushBlock.AGE, 3).m_67697_((Property)TallFoulBerryBushBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AutumnityItems.FOUL_BERRIES.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)TallFoulBerryBushBlock.AGE, 2).m_67697_((Property)TallFoulBerryBushBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AutumnityItems.FOUL_BERRIES.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)))));
            this.m_124252_((Block)AutumnityBlocks.POTTED_FOUL_BERRIES.get());
            this.m_124288_((Block)AutumnityBlocks.FOUL_BERRY_BASKET.get());
            this.m_124288_((Block)AutumnityBlocks.SOUL_JACK_O_LANTERN.get());
            this.m_124288_((Block)AutumnityBlocks.REDSTONE_JACK_O_LANTERN.get());
            this.m_124288_((Block)AutumnityBlocks.ENDER_JACK_O_LANTERN.get());
            this.m_124288_((Block)AutumnityBlocks.CUPRIC_JACK_O_LANTERN.get());
            this.m_124288_((Block)AutumnityBlocks.LARGE_PUMPKIN_SLICE.get());
            this.m_124288_((Block)AutumnityBlocks.CARVED_LARGE_PUMPKIN_SLICE.get());
            this.m_124288_((Block)AutumnityBlocks.LARGE_JACK_O_LANTERN_SLICE.get());
            this.m_124288_((Block)AutumnityBlocks.LARGE_SOUL_JACK_O_LANTERN_SLICE.get());
            this.m_124288_((Block)AutumnityBlocks.LARGE_REDSTONE_JACK_O_LANTERN_SLICE.get());
            this.m_124288_((Block)AutumnityBlocks.LARGE_ENDER_JACK_O_LANTERN_SLICE.get());
            this.m_124288_((Block)AutumnityBlocks.LARGE_CUPRIC_JACK_O_LANTERN_SLICE.get());
            this.m_124288_((Block)AutumnityBlocks.SNAIL_SHELL_BLOCK.get());
            this.m_124288_((Block)AutumnityBlocks.SNAIL_SHELL_BRICKS.get());
            this.m_124288_((Block)AutumnityBlocks.SNAIL_SHELL_BRICK_STAIRS.get());
            this.m_124288_((Block)AutumnityBlocks.SNAIL_SHELL_BRICK_WALL.get());
            this.m_124175_((Block)AutumnityBlocks.SNAIL_SHELL_BRICK_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)AutumnityBlocks.SNAIL_SHELL_BRICK_VERTICAL_SLAB.get(), AutumnityBlockLoot::createVerticalSlabItemTable);
            this.m_124288_((Block)AutumnityBlocks.CHISELED_SNAIL_SHELL_BRICKS.get());
            this.m_124288_((Block)AutumnityBlocks.SNAIL_SHELL_TILES.get());
            this.m_124288_((Block)AutumnityBlocks.SNAIL_SHELL_TILE_STAIRS.get());
            this.m_124288_((Block)AutumnityBlocks.SNAIL_SHELL_TILE_WALL.get());
            this.m_124175_((Block)AutumnityBlocks.SNAIL_SHELL_TILE_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)AutumnityBlocks.SNAIL_SHELL_TILE_VERTICAL_SLAB.get(), AutumnityBlockLoot::createVerticalSlabItemTable);
            this.m_124288_((Block)AutumnityBlocks.MAPLE_PLANKS.get());
            this.m_124288_((Block)AutumnityBlocks.VERTICAL_MAPLE_PLANKS.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_LOG.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_WOOD.get());
            this.m_124288_((Block)AutumnityBlocks.STRIPPED_MAPLE_LOG.get());
            this.m_124288_((Block)AutumnityBlocks.STRIPPED_MAPLE_WOOD.get());
            this.m_124288_((Block)AutumnityBlocks.SAPPY_MAPLE_LOG.get());
            this.m_124288_((Block)AutumnityBlocks.SAPPY_MAPLE_WOOD.get());
            this.m_124288_((Block)((RegistryObject)AutumnityBlocks.MAPLE_SIGN.getFirst()).get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_PRESSURE_PLATE.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_TRAPDOOR.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_BUTTON.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_STAIRS.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_FENCE.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_FENCE_GATE.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_BOARDS.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_POST.get());
            this.m_124288_((Block)AutumnityBlocks.STRIPPED_MAPLE_POST.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_HEDGE.get());
            this.m_124288_((Block)AutumnityBlocks.YELLOW_MAPLE_HEDGE.get());
            this.m_124288_((Block)AutumnityBlocks.ORANGE_MAPLE_HEDGE.get());
            this.m_124288_((Block)AutumnityBlocks.RED_MAPLE_HEDGE.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_LEAF_CARPET.get());
            this.m_124288_((Block)AutumnityBlocks.YELLOW_MAPLE_LEAF_CARPET.get());
            this.m_124288_((Block)AutumnityBlocks.ORANGE_MAPLE_LEAF_CARPET.get());
            this.m_124288_((Block)AutumnityBlocks.RED_MAPLE_LEAF_CARPET.get());
            this.m_124175_((Block)AutumnityBlocks.MAPLE_LEAF_PILE.get(), AutumnityBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)AutumnityBlocks.YELLOW_MAPLE_LEAF_PILE.get(), AutumnityBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)AutumnityBlocks.ORANGE_MAPLE_LEAF_PILE.get(), AutumnityBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)AutumnityBlocks.RED_MAPLE_LEAF_PILE.get(), AutumnityBlockLoot::createLeafPileDrops);
            this.m_124288_((Block)AutumnityBlocks.MAPLE_SAPLING.get());
            this.m_124288_((Block)AutumnityBlocks.YELLOW_MAPLE_SAPLING.get());
            this.m_124288_((Block)AutumnityBlocks.ORANGE_MAPLE_SAPLING.get());
            this.m_124288_((Block)AutumnityBlocks.RED_MAPLE_SAPLING.get());
            this.m_124252_((Block)AutumnityBlocks.POTTED_MAPLE_SAPLING.get());
            this.m_124252_((Block)AutumnityBlocks.POTTED_YELLOW_MAPLE_SAPLING.get());
            this.m_124252_((Block)AutumnityBlocks.POTTED_ORANGE_MAPLE_SAPLING.get());
            this.m_124252_((Block)AutumnityBlocks.POTTED_RED_MAPLE_SAPLING.get());
            this.m_124288_((Block)AutumnityBlocks.MAPLE_LADDER.get());
            this.m_124175_((Block)AutumnityBlocks.MAPLE_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)AutumnityBlocks.MAPLE_VERTICAL_SLAB.get(), AutumnityBlockLoot::createVerticalSlabItemTable);
            this.m_124175_((Block)AutumnityBlocks.MAPLE_DOOR.get(), BlockLoot::m_124137_);
            this.m_124175_((Block)AutumnityBlocks.MAPLE_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)((RegistryObject)AutumnityBlocks.MAPLE_CHEST.getFirst()).get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)((RegistryObject)AutumnityBlocks.MAPLE_CHEST.getSecond()).get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)AutumnityBlocks.MAPLE_BOOKSHELF.get(), block -> AutumnityBlockLoot.m_176042_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_124175_((Block)AutumnityBlocks.MAPLE_LEAVES.get(), block -> AutumnityBlockLoot.m_124157_((Block)block, (Block)((Block)AutumnityBlocks.MAPLE_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124175_((Block)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get(), block -> AutumnityBlockLoot.m_124157_((Block)block, (Block)((Block)AutumnityBlocks.YELLOW_MAPLE_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124175_((Block)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get(), block -> AutumnityBlockLoot.m_124157_((Block)block, (Block)((Block)AutumnityBlocks.ORANGE_MAPLE_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124175_((Block)AutumnityBlocks.RED_MAPLE_LEAVES.get(), block -> AutumnityBlockLoot.m_124157_((Block)block, (Block)((Block)AutumnityBlocks.RED_MAPLE_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
        }

        protected static LootTable.Builder createLeafPileDrops(Block block) {
            return AutumnityBlockLoot.m_236227_((Block)block, (LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS)));
        }

        protected static LootTable.Builder createVerticalSlabItemTable(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AutumnityBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE)))))));
        }

        protected static LootTable.Builder createTurkeyDrops(Block block, Item piece) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)TurkeyBlock.CHUNKS, 0))), AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)piece).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)TurkeyBlock.CHUNKS, 4))), LootItem.m_79579_((ItemLike)piece).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)TurkeyBlock.CHUNKS, 3))), LootItem.m_79579_((ItemLike)piece).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)TurkeyBlock.CHUNKS, 2))), LootItem.m_79579_((ItemLike)piece).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)TurkeyBlock.CHUNKS, 1)))})})));
        }

        protected static LootTable.Builder createPancakeDrops(Block block) {
            LootPoolSingletonContainer.Builder item = LootItem.m_79579_((ItemLike)block);
            for (int i = 1; i < 33; ++i) {
                item.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(i / 2))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PancakeBlock.PANCAKES, i))));
            }
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AutumnityBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)item)));
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("autumnity")).collect(Collectors.toSet());
        }
    }
}

