/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.autumnity.core.other.tags.AutumnityBiomeTags;
import com.teamabnormals.autumnity.core.registry.AutumnityEntityTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityFeatures;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AutumnityBiomeModifierProvider {
    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        RegistryAccess.Writable access = RegistryAccess.m_206197_();
        Registry biomeRegistry = access.m_175515_(Registry.f_122885_);
        Registry placedFeatures = access.m_175515_(Registry.f_194567_);
        HashMap<ResourceLocation, BiomeModifier> modifiers = new HashMap<ResourceLocation, BiomeModifier>();
        AutumnityBiomeModifierProvider.addModifier(modifiers, "add_feature/maple_tree", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(AutumnityBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, AutumnityBiomeTags.HAS_MAPLE_TREE), AutumnityBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, AutumnityFeatures.AutumnityPlacedFeatures.TREES_MAPLE), GenerationStep.Decoration.VEGETAL_DECORATION));
        AutumnityBiomeModifierProvider.addModifier(modifiers, "add_feature/spotted_maple_tree/yellow", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(AutumnityBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, AutumnityBiomeTags.HAS_YELLOW_MAPLE_TREE), AutumnityBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, AutumnityFeatures.AutumnityPlacedFeatures.TREES_MAPLE_YELLOW), GenerationStep.Decoration.VEGETAL_DECORATION));
        AutumnityBiomeModifierProvider.addModifier(modifiers, "add_feature/spotted_maple_tree/orange", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(AutumnityBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, AutumnityBiomeTags.HAS_ORANGE_MAPLE_TREE), AutumnityBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, AutumnityFeatures.AutumnityPlacedFeatures.TREES_MAPLE_ORANGE), GenerationStep.Decoration.VEGETAL_DECORATION));
        AutumnityBiomeModifierProvider.addModifier(modifiers, "add_feature/spotted_maple_tree/red", (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(AutumnityBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, AutumnityBiomeTags.HAS_RED_MAPLE_TREE), AutumnityBiomeModifierProvider.of((Registry<PlacedFeature>)placedFeatures, AutumnityFeatures.AutumnityPlacedFeatures.TREES_MAPLE_RED), GenerationStep.Decoration.VEGETAL_DECORATION));
        AutumnityBiomeModifierProvider.addModifier(modifiers, "remove_animal/chicken", (BiomeModifier)new ForgeBiomeModifiers.RemoveSpawnsBiomeModifier(AutumnityBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, AutumnityBiomeTags.HAS_TURKEY), (HolderSet)HolderSet.m_205800_(List.of((Holder)ForgeRegistries.ENTITY_TYPES.getHolder((Object)EntityType.f_20555_).get()))));
        AutumnityBiomeModifierProvider.addModifier(modifiers, "add_animal/turkey", (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(AutumnityBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, AutumnityBiomeTags.HAS_TURKEY), List.of(new MobSpawnSettings.SpawnerData((EntityType)AutumnityEntityTypes.TURKEY.get(), 10, 4, 4))));
        AutumnityBiomeModifierProvider.addModifier(modifiers, "add_animal/snail", (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(AutumnityBiomeModifierProvider.tag((Registry<Biome>)biomeRegistry, AutumnityBiomeTags.HAS_SNAIL), List.of(new MobSpawnSettings.SpawnerData((EntityType)AutumnityEntityTypes.SNAIL.get(), 10, 2, 2))));
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"autumnity", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)access), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, modifiers);
    }

    private static HolderSet<Biome> tag(Registry<Biome> biomeRegistry, TagKey<Biome> tagKey) {
        return new HolderSet.Named(biomeRegistry, tagKey);
    }

    private static void addModifier(HashMap<ResourceLocation, BiomeModifier> modifiers, String name, BiomeModifier modifier) {
        modifiers.put(new ResourceLocation("autumnity", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> of(Registry<PlacedFeature> placedFeatures, RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> placedFeatures.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

