/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core.other;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.autumnity.common.block.RedstoneJackOLanternBlock;
import com.teamabnormals.autumnity.common.block.TurkeyBlock;
import com.teamabnormals.autumnity.common.block.util.JackOLanternUtil;
import com.teamabnormals.autumnity.common.entity.animal.Snail;
import com.teamabnormals.autumnity.core.AutumnityConfig;
import com.teamabnormals.autumnity.core.other.AutumnityConstants;
import com.teamabnormals.autumnity.core.other.AutumnityCriteriaTriggers;
import com.teamabnormals.autumnity.core.other.tags.AutumnityEntityTypeTags;
import com.teamabnormals.autumnity.core.registry.AutumnityBiomes;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import com.teamabnormals.autumnity.core.registry.AutumnityMobEffects;
import com.teamabnormals.blueprint.core.events.FallingBlockEvent;
import com.teamabnormals.blueprint.core.util.TradeUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="autumnity")
public class AutumnityEvents {
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(UUID.fromString("98D5CD1F-601F-47E6-BEEC-5997E1C4216F"), "Knockback modifier", 1.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (((Boolean)AutumnityConfig.COMMON.foulBerriesRequirePips.get()).booleanValue() && stack.m_150930_((Item)AutumnityItems.FOUL_BERRIES.get())) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (!level.f_46443_) {
            Entity entity = event.getEntity();
            if (entity instanceof Pillager) {
                ((PathfinderMob)entity).f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), Snail.class, true));
            } else if (entity instanceof MushroomCow) {
                ((PathfinderMob)entity).f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)entity, Snail.class, 16.0f, 1.25, 1.6, EntitySelector.f_20406_::test));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        LevelAccessor level = event.getLevel();
        Mob entity = event.getEntity();
        if ((entity instanceof Zombie || entity instanceof AbstractSkeleton) && entity.m_6844_(EquipmentSlot.HEAD).m_41619_() && level.m_204166_(entity.m_20183_()).m_203373_(AutumnityBiomes.PUMPKIN_FIELDS.getKey().m_135782_()) && level.m_213780_().m_188501_() < 0.05f) {
            entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Blocks.f_50143_));
            entity.m_21409_(EquipmentSlot.HEAD, 0.0f);
        }
    }

    @SubscribeEvent
    public static void onSnailShellChestplateSneak(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        entity.m_21051_(Attributes.f_22278_).m_22130_(KNOCKBACK_MODIFIER);
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == AutumnityItems.SNAIL_SHELL_CHESTPLATE.get() && entity.m_6144_()) {
            entity.m_21051_(Attributes.f_22278_).m_22118_(KNOCKBACK_MODIFIER);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Direction facing;
        Direction hitface;
        Block jackolantern;
        Level level = event.getLevel();
        Player player = event.getEntity();
        ItemStack itemstack = event.getItemStack();
        Item item = itemstack.m_41720_();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!player.m_5833_()) {
            if (item == AutumnityItems.FOUL_BERRIES.get() && ModList.get().isLoaded("berry_good")) {
                event.setUseItem(Event.Result.DENY);
            } else if (player.m_21023_((MobEffect)AutumnityMobEffects.FOUL_TASTE.get()) && player.m_36391_(false) && (block instanceof CakeBlock || ModList.get().isLoaded("atmospheric") && block == ForgeRegistries.BLOCKS.getValue(AutumnityConstants.YUCCA_GATEAU))) {
                if (player.m_36324_().m_38702_() < 19) {
                    player.m_36324_().m_38707_(1, 0.0f);
                }
                AutumnityEvents.updateFoulTaste(player);
            }
        }
        if (block == Blocks.f_50143_ && (jackolantern = JackOLanternUtil.getJackOLantern(itemstack)) instanceof CarvedPumpkinBlock && (hitface = event.getFace()) == (facing = (Direction)state.m_61143_((Property)CarvedPumpkinBlock.f_51367_))) {
            if (!level.m_5776_()) {
                BlockState blockstate = (BlockState)jackolantern.m_49966_().m_61124_((Property)CarvedPumpkinBlock.f_51367_, (Comparable)facing);
                if (jackolantern == AutumnityBlocks.LARGE_REDSTONE_JACK_O_LANTERN_SLICE.get()) {
                    blockstate = (BlockState)blockstate.m_61124_((Property)RedstoneJackOLanternBlock.LIT, (Comparable)Boolean.valueOf(level.m_46753_(pos)));
                }
                level.m_7731_(pos, blockstate, 11);
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
        }
    }

    @SubscribeEvent
    public static void onFoulBerriesEaten(LivingEntityUseItemEvent.Finish event) {
        ItemStack itemstack = event.getItem();
        if (event.getEntity().m_21023_((MobEffect)AutumnityMobEffects.FOUL_TASTE.get()) && event.getEntity() instanceof Player && itemstack.m_41614_()) {
            Item item = itemstack.m_41720_();
            FoodProperties food = item.m_41473_();
            boolean flag = true;
            if (item instanceof SuspiciousStewItem) {
                CompoundTag compoundnbt = itemstack.m_41783_();
                if (compoundnbt != null && compoundnbt.m_128425_("Effects", 9)) {
                    ListTag listnbt = compoundnbt.m_128437_("Effects", 10);
                    for (int i = 0; i < listnbt.size(); ++i) {
                        CompoundTag compoundnbt1 = listnbt.m_128728_(i);
                        MobEffect effect = MobEffect.m_19453_((int)compoundnbt1.m_128445_("EffectId"));
                        if (effect != AutumnityMobEffects.FOUL_TASTE.get()) continue;
                        flag = false;
                        break;
                    }
                }
            } else {
                for (Pair pair : food.m_38749_()) {
                    if (((MobEffectInstance)pair.getFirst()).m_19544_() != AutumnityMobEffects.FOUL_TASTE.get()) continue;
                    flag = false;
                    break;
                }
            }
            if (flag) {
                Player player = (Player)event.getEntity();
                int i = food.m_38744_();
                int j = Math.max(1, (int)((float)i * 0.5f));
                player.m_36324_().m_38707_(j, 0.0f);
                AutumnityEvents.updateFoulTaste(player);
            }
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(5, ((Block)AutumnityBlocks.MAPLE_SAPLING.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AutumnityBlocks.YELLOW_MAPLE_SAPLING.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AutumnityBlocks.ORANGE_MAPLE_SAPLING.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AutumnityBlocks.RED_MAPLE_SAPLING.get()).m_5456_(), 1, 8, 1), new TradeUtil.BlueprintTrade(4, ((Block)AutumnityBlocks.SNAIL_GOO.get()).m_5456_(), 1, 5, 1)});
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.f_35590_, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(2, (Item)AutumnityItems.FOUL_BERRIES.get(), 16, 12, 10)});
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.f_35587_, (int)3, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(((Block)AutumnityBlocks.TURKEY.get()).m_5456_(), 6, 1, 16, 20)});
    }

    @SubscribeEvent
    public static void onPotionAdded(MobEffectEvent.Added event) {
        LivingEntity livingentity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        MobEffectInstance extension = livingentity.m_21124_((MobEffect)AutumnityMobEffects.EXTENSION.get());
        if (extension != null && effect.m_19544_() != AutumnityMobEffects.EXTENSION.get()) {
            effect.m_19558_(new MobEffectInstance(effect.m_19544_(), effect.m_19557_() + 300 + 300 * (extension.m_19564_() + 1), effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
        }
    }

    @SubscribeEvent
    public static void onFallingBlockTick(FallingBlockEvent.FallingBlockTickEvent event) {
        FallingBlockEntity fallingblock = event.getEntity();
        Level level = fallingblock.m_9236_();
        BlockState state = fallingblock.m_31980_();
        if (!level.m_5776_() && state.m_60734_() instanceof TurkeyBlock && (Integer)state.m_61143_((Property)TurkeyBlock.CHUNKS) == 0 && fallingblock.m_20184_().m_7098_() < 0.0) {
            AABB aabb = fallingblock.m_20191_().m_82377_(0.0, 0.2, 0.0);
            for (Entity entity2 : level.m_6249_((Entity)fallingblock, aabb, entity -> entity.m_6095_().m_204039_(AutumnityEntityTypeTags.CAN_WEAR_TURKEY) && ((LivingEntity)entity).m_6844_(EquipmentSlot.HEAD).m_41619_())) {
                if (!(fallingblock.m_20186_() >= (double)entity2.m_20192_())) continue;
                entity2.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)state.m_60734_().m_5456_()));
                fallingblock.m_146870_();
                event.setCanceled(true);
                break;
            }
        }
    }

    public static void updateFoulTaste(Player player) {
        MobEffectInstance effect = player.m_21124_((MobEffect)AutumnityMobEffects.FOUL_TASTE.get());
        player.m_21195_((MobEffect)AutumnityMobEffects.FOUL_TASTE.get());
        if (effect.m_19564_() > 0) {
            player.m_7292_(new MobEffectInstance((MobEffect)AutumnityMobEffects.FOUL_TASTE.get(), effect.m_19557_(), effect.m_19564_() - 1));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            if (!player.m_20193_().m_5776_()) {
                AutumnityCriteriaTriggers.CURE_FOUL_TASTE.trigger(serverplayerentity);
            }
        }
    }
}

