/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core.registry;

import com.teamabnormals.autumnity.core.Autumnity;
import com.teamabnormals.autumnity.core.registry.AutumnityFeatures;
import com.teamabnormals.blueprint.core.util.registry.BiomeSubRegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AutumnityBiomes {
    public static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Autumnity.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome MAPLE_FOREST = HELPER.createBiome("maple_forest", AutumnityBiomes::mapleForest);
    public static final BiomeSubRegistryHelper.KeyedBiome PUMPKIN_FIELDS = HELPER.createBiome("pumpkin_fields", AutumnityBiomes::pumpkinFields);

    private static Biome mapleForest() {
        MobSpawnSettings.Builder spawns = AutumnityBiomes.baseMapleSpawns();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)AutumnityFeatures.AutumnityPlacedFeatures.MAPLE_FOREST_VEGETATION.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)AutumnityFeatures.AutumnityPlacedFeatures.FLOWER_MAPLE_FOREST.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)AutumnityFeatures.AutumnityPlacedFeatures.FALLEN_LEAVES.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)AutumnityFeatures.AutumnityPlacedFeatures.PATCH_FOUL_BERRY_BUSH.getHolder().get());
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.7f).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(AutumnityBiomes.calculateSkyColor(0.7f)).m_48043_(10471748).m_48045_(10139705).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(OverworldBiomes.f_194839_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static Biome pumpkinFields() {
        MobSpawnSettings.Builder spawns = AutumnityBiomes.baseMapleSpawns();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195451_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)AutumnityFeatures.AutumnityPlacedFeatures.PUMPKIN_FIELDS_VEGETATION.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)AutumnityFeatures.AutumnityPlacedFeatures.FLOWER_PUMPKIN_FIELDS.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)AutumnityFeatures.AutumnityPlacedFeatures.PATCH_TALL_GRASS_PUMPKIN_FIELDS.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)AutumnityFeatures.AutumnityPlacedFeatures.PATCH_PUMPKIN_PUMPKIN_FIELDS.getHolder().get());
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(AutumnityBiomes.calculateSkyColor(0.8f)).m_48043_(10471748).m_48045_(10139705).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(OverworldBiomes.f_194839_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static MobSpawnSettings.Builder baseMapleSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        return spawns;
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

