/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamabnormals.autumnity.common.block.TallFoulBerryBushBlock;
import com.teamabnormals.autumnity.common.levelgen.feature.FallenLeavesFeature;
import com.teamabnormals.autumnity.common.levelgen.feature.FallenLeavesMapleTreeFeature;
import com.teamabnormals.autumnity.common.levelgen.feature.MapleTreeFeature;
import com.teamabnormals.autumnity.common.levelgen.feature.PumpkinFieldsPumpkinFeature;
import com.teamabnormals.autumnity.common.levelgen.placement.BetterNoiseBasedCountPlacement;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityNoiseParameters;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AutumnityFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"autumnity");
    public static final RegistryObject<Feature<TreeConfiguration>> MAPLE_TREE = FEATURES.register("maple_tree", () -> new MapleTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> FALLEN_LEAVES_MAPLE_TREE = FEATURES.register("fallen_leaves_maple_tree", () -> new FallenLeavesMapleTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FALLEN_LEAVES = FEATURES.register("fallen_leaves", () -> new FallenLeavesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PUMPKIN_FIELDS_PUMPKIN = FEATURES.register("pumpkin_fields_pumpkin", () -> new PumpkinFieldsPumpkinFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public static final class AutumnityPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"autumnity");
        public static final RegistryObject<PlacedFeature> MAPLE_TREE_CHECKED = AutumnityPlacedFeatures.register("maple_tree_checked", AutumnityConfiguredFeatures.MAPLE_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> RED_MAPLE_TREE_CHECKED = AutumnityPlacedFeatures.register("red_maple_tree_checked", AutumnityConfiguredFeatures.MAPLE_TREE_RED, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> FALLEN_LEAVES_YELLOW_MAPLE_TREE_CHECKED = AutumnityPlacedFeatures.register("fallen_leaves_yellow_maple_tree_checked", AutumnityConfiguredFeatures.FALLEN_LEAVES_MAPLE_TREE_YELLOW, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> FALLEN_LEAVES_ORANGE_MAPLE_TREE_CHECKED = AutumnityPlacedFeatures.register("fallen_leaves_orange_maple_tree_checked", AutumnityConfiguredFeatures.FALLEN_LEAVES_MAPLE_TREE_ORANGE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> TREES_MAPLE = AutumnityPlacedFeatures.register("trees_maple", AutumnityConfiguredFeatures.MAPLE_TREE, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> TREES_MAPLE_YELLOW = AutumnityPlacedFeatures.register("trees_maple_yellow", AutumnityConfiguredFeatures.MAPLE_TREE_YELLOW, (List<PlacementModifier>)AutumnityPlacedFeatures.treePlacementBase(AutumnityPlacementUtils.SPOTTED_MAPLES_COUNT).build());
        public static final RegistryObject<PlacedFeature> TREES_MAPLE_ORANGE = AutumnityPlacedFeatures.register("trees_maple_orange", AutumnityConfiguredFeatures.MAPLE_TREE_ORANGE, (List<PlacementModifier>)AutumnityPlacedFeatures.treePlacementBase(AutumnityPlacementUtils.SPOTTED_MAPLES_COUNT).build());
        public static final RegistryObject<PlacedFeature> TREES_MAPLE_RED = AutumnityPlacedFeatures.register("trees_maple_red", AutumnityConfiguredFeatures.MAPLE_TREE_RED, (List<PlacementModifier>)AutumnityPlacedFeatures.treePlacementBase(AutumnityPlacementUtils.SPOTTED_MAPLES_COUNT).build());
        public static final RegistryObject<PlacedFeature> FALLEN_LEAVES = AutumnityPlacedFeatures.register("fallen_leaves", AutumnityConfiguredFeatures.FALLEN_LEAVES, new PlacementModifier[]{RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_FOUL_BERRY_BUSH = AutumnityPlacedFeatures.register("patch_foul_berry_bush", AutumnityConfiguredFeatures.PATCH_FOUL_BERRY_BUSH, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_MAPLE_FOREST = AutumnityPlacedFeatures.register("flower_maple_forest", AutumnityConfiguredFeatures.FLOWER_MAPLE_FOREST, new PlacementModifier[]{RarityFilter.m_191900_((int)7), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> MAPLE_FOREST_VEGETATION = AutumnityPlacedFeatures.register("maple_forest_vegetation", AutumnityConfiguredFeatures.MAPLE_FOREST_VEGETATION, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> PUMPKIN_FIELDS_VEGETATION = AutumnityPlacedFeatures.register("pumpkin_fields_vegetation", AutumnityConfiguredFeatures.MAPLE_FOREST_VEGETATION, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.2f, (int)1)));
        public static final RegistryObject<PlacedFeature> PATCH_TALL_GRASS_PUMPKIN_FIELDS = AutumnityPlacedFeatures.register("patch_tall_grass_pumpkin_fields", AutumnityConfiguredFeatures.PATCH_TALL_GRASS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_PUMPKIN_PUMPKIN_FIELDS = AutumnityPlacedFeatures.register("patch_pumpkin_pumpkin_fields", AutumnityConfiguredFeatures.PATCH_PUMPKINS_PUMPKIN_FIELDS, new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_PUMPKIN_FIELDS = AutumnityPlacedFeatures.register("flower_pumpkin_fields", AutumnityConfiguredFeatures.FLOWER_PUMPKIN_FIELDS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)15, (int)4), RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});

        private static ImmutableList.Builder<PlacementModifier> treePlacementBase(PlacementModifier modifier) {
            return ImmutableList.builder().add((Object)modifier).add((Object)InSquarePlacement.m_191715_()).add((Object)VegetationPlacements.f_195420_).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_());
        }

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... placementModifiers) {
            return AutumnityPlacedFeatures.register(name, feature, List.of(placementModifiers));
        }

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Collection)placementModifiers)));
        }
    }

    public static final class AutumnityConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"autumnity");
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MAPLE_TREE = AutumnityConfiguredFeatures.register("maple_tree", () -> new ConfiguredFeature((Feature)MAPLE_TREE.get(), (FeatureConfiguration)Configs.MAPLE_TREE_CONFIG));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MAPLE_TREE_YELLOW = AutumnityConfiguredFeatures.register("maple_tree_yellow", () -> new ConfiguredFeature((Feature)MAPLE_TREE.get(), (FeatureConfiguration)Configs.YELLOW_MAPLE_TREE_CONFIG));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> FALLEN_LEAVES_MAPLE_TREE_YELLOW = AutumnityConfiguredFeatures.register("fallen_leaves_maple_tree_yellow", () -> new ConfiguredFeature((Feature)FALLEN_LEAVES_MAPLE_TREE.get(), (FeatureConfiguration)Configs.YELLOW_MAPLE_TREE_CONFIG));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MAPLE_TREE_ORANGE = AutumnityConfiguredFeatures.register("maple_tree_orange", () -> new ConfiguredFeature((Feature)MAPLE_TREE.get(), (FeatureConfiguration)Configs.ORANGE_MAPLE_TREE_CONFIG));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> FALLEN_LEAVES_MAPLE_TREE_ORANGE = AutumnityConfiguredFeatures.register("fallen_leaves_maple_tree_orange", () -> new ConfiguredFeature((Feature)FALLEN_LEAVES_MAPLE_TREE.get(), (FeatureConfiguration)Configs.ORANGE_MAPLE_TREE_CONFIG));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> MAPLE_TREE_RED = AutumnityConfiguredFeatures.register("maple_tree_red", () -> new ConfiguredFeature((Feature)MAPLE_TREE.get(), (FeatureConfiguration)Configs.RED_MAPLE_TREE_CONFIG));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> FALLEN_LEAVES = AutumnityConfiguredFeatures.register("fallen_leaves", () -> new ConfiguredFeature((Feature)FALLEN_LEAVES.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> MAPLE_FOREST_VEGETATION = AutumnityConfiguredFeatures.register("maple_forest_vegetation", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)TreeFeatures.f_195121_, (PlacementModifier[])new PlacementModifier[0]), 0.025f), new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)TreeFeatures.f_195122_, (PlacementModifier[])new PlacementModifier[0]), 0.05f), new WeightedPlacedFeature((Holder)AutumnityPlacedFeatures.RED_MAPLE_TREE_CHECKED.getHolder().get(), 0.3f), new WeightedPlacedFeature((Holder)AutumnityPlacedFeatures.FALLEN_LEAVES_ORANGE_MAPLE_TREE_CHECKED.getHolder().get(), 0.4f), new WeightedPlacedFeature((Holder)AutumnityPlacedFeatures.FALLEN_LEAVES_YELLOW_MAPLE_TREE_CHECKED.getHolder().get(), 0.2f)), (Holder)AutumnityPlacedFeatures.MAPLE_TREE_CHECKED.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_TALL_GRASS = AutumnityConfiguredFeatures.register("patch_tall_grass", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50359_)))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_FOUL_BERRY_BUSH = AutumnityConfiguredFeatures.register("patch_foul_berry_bush", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get()).m_49966_().m_61124_((Property)TallFoulBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.f_50440_))));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_PUMPKINS_PUMPKIN_FIELDS = AutumnityConfiguredFeatures.register("patch_pumpkins_pumpkin_fields", () -> new ConfiguredFeature((Feature)PUMPKIN_FIELDS_PUMPKIN.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> FLOWER_MAPLE_FOREST = AutumnityConfiguredFeatures.register("forest_flowers", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50357_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65762_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AutumnityBlocks.AUTUMN_CROCUS.get())))), (PlacementModifier[])new PlacementModifier[0])}))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_PUMPKIN_FIELDS = AutumnityConfiguredFeatures.register("flower_plain", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206470_((int)64, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)AutumnityBlocks.AUTUMN_CROCUS.get()).m_49966_(), 1).m_146271_((Object)Blocks.f_50120_.m_49966_(), 1).m_146271_((Object)Blocks.f_50121_.m_49966_(), 1)))))));

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }
    }

    public static final class AutumnityPlacementUtils {
        public static final BetterNoiseBasedCountPlacement SPOTTED_MAPLES_COUNT = new BetterNoiseBasedCountPlacement((Holder<NormalNoise.NoiseParameters>)((Holder)AutumnityNoiseParameters.SPOTTED_MAPLES.getHolder().orElseThrow()), 12, -0.4f);
    }

    public static final class Configs {
        public static final TreeConfiguration MAPLE_TREE_CONFIG = Configs.createMaple(States.MAPLE_LEAVES).m_68251_();
        public static final TreeConfiguration YELLOW_MAPLE_TREE_CONFIG = Configs.createMaple(States.YELLOW_MAPLE_LEAVES).m_68251_();
        public static final TreeConfiguration ORANGE_MAPLE_TREE_CONFIG = Configs.createMaple(States.ORANGE_MAPLE_LEAVES).m_68251_();
        public static final TreeConfiguration RED_MAPLE_TREE_CONFIG = Configs.createMaple(States.RED_MAPLE_LEAVES).m_68251_();

        private static TreeConfiguration.TreeConfigurationBuilder createMaple(BlockState leavesState) {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)States.MAPLE_LOG), (TrunkPlacer)new StraightTrunkPlacer(5, 1, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)leavesState), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68244_();
        }
    }

    public static final class States {
        private static final BlockState MAPLE_LOG = ((Block)AutumnityBlocks.MAPLE_LOG.get()).m_49966_();
        private static final BlockState MAPLE_LEAVES = ((Block)AutumnityBlocks.MAPLE_LEAVES.get()).m_49966_();
        private static final BlockState YELLOW_MAPLE_LEAVES = ((Block)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get()).m_49966_();
        private static final BlockState ORANGE_MAPLE_LEAVES = ((Block)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get()).m_49966_();
        private static final BlockState RED_MAPLE_LEAVES = ((Block)AutumnityBlocks.RED_MAPLE_LEAVES.get()).m_49966_();
    }
}

