/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.client;

import com.illusivesoulworks.bedspreads.common.DecoratedBedBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DecoratedBedBlockEntityRenderer
implements BlockEntityRenderer<DecoratedBedBlockEntity> {
    private final ModelPart headPiece;
    private final ModelPart footPiece;

    public DecoratedBedBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.headPiece = ctx.m_173582_(ModelLayers.f_171267_);
        this.footPiece = ctx.m_173582_(ModelLayers.f_171266_);
    }

    public void render(@Nonnull DecoratedBedBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        List<Pair<Holder<BannerPattern>, DyeColor>> list = blockEntity.getPatternList();
        Level world = blockEntity.m_58904_();
        if (world != null) {
            BlockState blockstate = blockEntity.m_58900_();
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = DoubleBlockCombiner.m_52822_((BlockEntityType)BlockEntityType.f_58940_, BedBlock::m_49559_, BedBlock::m_49557_, (DirectionProperty)ChestBlock.f_51478_, (BlockState)blockstate, (LevelAccessor)world, (BlockPos)blockEntity.m_58899_(), (p_228846_0_, p_228846_1_) -> false);
            int i = ((Int2IntFunction)icallbackwrapper.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(light);
            this.renderPiece(poseStack, buffer, blockstate.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? this.headPiece : this.footPiece, (Direction)blockstate.m_61143_((Property)BedBlock.f_54117_), i, overlay, false, list);
        } else {
            this.renderPiece(poseStack, buffer, this.headPiece, Direction.SOUTH, light, overlay, false, list);
            this.renderPiece(poseStack, buffer, this.footPiece, Direction.SOUTH, light, overlay, true, list);
        }
    }

    private void renderPiece(PoseStack poseStack, MultiBufferSource buffer, ModelPart modelPart, Direction direction, int light, int overlay, boolean isHead, List<Pair<Holder<BannerPattern>, DyeColor>> patterns) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5625, isHead ? -1.0 : 0.0);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f + direction.m_122435_()));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        Material material = new Material(InventoryMenu.f_39692_, new ResourceLocation("bedspreads", "entity/bed_base"));
        if (patterns != null) {
            DecoratedBedBlockEntityRenderer.renderPatterns(poseStack, buffer, light, overlay, modelPart, patterns);
        }
        VertexConsumer ivertexbuilder = material.m_119194_(buffer, RenderType::m_110473_);
        modelPart.m_104301_(poseStack, ivertexbuilder, light, overlay);
        poseStack.m_85849_();
    }

    public static void renderPatterns(PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, ModelPart modelRenderer, List<Pair<Holder<BannerPattern>, DyeColor>> patterns) {
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<Holder<BannerPattern>, DyeColor> pair = patterns.get(i);
            float[] afloat = ((DyeColor)pair.getSecond()).m_41068_();
            Material patternMaterial = new Material(InventoryMenu.f_39692_, new ResourceLocation("bedspreads", "entity/" + ((Holder)pair.getFirst()).m_203543_().map(key -> {
                ResourceLocation loc = key.m_135782_();
                return loc.m_135827_() + "/" + loc.m_135815_();
            }).orElse("minecraft/base")));
            modelRenderer.m_104306_(poseStack, patternMaterial.m_119194_(buffer, RenderType::m_110473_), light, overlay, afloat[0], afloat[1], afloat[2], 1.0f);
        }
    }
}

