/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.TargetsHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;

public record BiomeEffectModifier(Optional<Integer> fogColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> skyColor, Optional<Integer> foliageColorOverride, Optional<Integer> grassColorOverride, Optional<BiomeSpecialEffects.GrassColorModifier> grassColorModifier, Optional<AmbientParticleSettings> ambientParticleSettings, Optional<SoundEvent> ambientLoopSoundEvent, Optional<AmbientMoodSettings> ambientMoodSettings, Optional<AmbientAdditionsSettings> ambientAdditionsSettings, Optional<Music> backgroundMusic, Optional<Set<ResourceLocation>> explicitTargets) {
    public static final Codec<BiomeEffectModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Codec.INT, "fog_color").forGetter(BiomeEffectModifier::fogColor), (App)StrOpt.of(Codec.INT, "water_color").forGetter(BiomeEffectModifier::waterColor), (App)StrOpt.of(Codec.INT, "water_fog_color").forGetter(BiomeEffectModifier::waterFogColor), (App)StrOpt.of(Codec.INT, "sky_color").forGetter(BiomeEffectModifier::skyColor), (App)StrOpt.of(Codec.INT, "foliage_color").forGetter(BiomeEffectModifier::foliageColorOverride), (App)StrOpt.of(Codec.INT, "grass_color").forGetter(BiomeEffectModifier::grassColorOverride), (App)StrOpt.of(BiomeSpecialEffects.GrassColorModifier.f_48050_, "grass_color_modifier").forGetter(BiomeEffectModifier::grassColorModifier), (App)StrOpt.of(AmbientParticleSettings.f_47412_, "particle").forGetter(BiomeEffectModifier::ambientParticleSettings), (App)StrOpt.of(SoundEvent.f_11655_, "ambient_sound").forGetter(BiomeEffectModifier::ambientLoopSoundEvent), (App)StrOpt.of(AmbientMoodSettings.f_47386_, "mood_sound").forGetter(BiomeEffectModifier::ambientMoodSettings), (App)StrOpt.of(AmbientAdditionsSettings.f_47371_, "additions_sound").forGetter(BiomeEffectModifier::ambientAdditionsSettings), (App)StrOpt.of(Music.f_11620_, "music").forGetter(BiomeEffectModifier::backgroundMusic), (App)StrOpt.of(TargetsHelper.CODEC, "targets").forGetter(BiomeEffectModifier::explicitTargets)).apply((Applicative)instance, BiomeEffectModifier::new));

    public BiomeEffectModifier merge(BiomeEffectModifier other) {
        return new BiomeEffectModifier(other.fogColor.isPresent() ? other.fogColor() : this.fogColor(), other.waterColor().isPresent() ? other.waterColor() : this.waterColor(), other.waterFogColor().isPresent() ? other.waterFogColor() : this.waterFogColor(), other.skyColor().isPresent() ? other.skyColor() : this.skyColor(), other.foliageColorOverride().isPresent() ? other.waterColor() : this.foliageColorOverride(), other.grassColorOverride().isPresent() ? other.grassColorOverride() : this.grassColorOverride(), other.grassColorModifier().isPresent() ? other.grassColorModifier() : this.grassColorModifier(), other.ambientParticleSettings().isPresent() ? other.ambientParticleSettings() : this.ambientParticleSettings(), other.ambientLoopSoundEvent().isPresent() ? other.ambientLoopSoundEvent() : this.ambientLoopSoundEvent(), other.ambientMoodSettings().isPresent() ? other.ambientMoodSettings() : this.ambientMoodSettings(), other.ambientAdditionsSettings().isPresent() ? other.ambientAdditionsSettings() : this.ambientAdditionsSettings(), other.backgroundMusic().isPresent() ? other.backgroundMusic() : this.backgroundMusic(), TargetsHelper.merge(other.explicitTargets, this.explicitTargets));
    }

    public BiomeSpecialEffects apply(Biome biome) {
        BiomeSpecialEffects effects = biome.m_47557_();
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        int newFog = effects.m_47967_();
        if (this.fogColor.isPresent()) {
            newFog = this.fogColor.get();
        }
        builder.m_48019_(newFog);
        int newWaterColor = effects.m_47972_();
        if (this.waterColor.isPresent()) {
            newWaterColor = this.waterColor.get();
        }
        builder.m_48034_(newWaterColor);
        int newWaterFogColor = effects.m_47975_();
        if (this.waterFogColor.isPresent()) {
            newWaterFogColor = this.waterFogColor.get();
        }
        builder.m_48037_(newWaterFogColor);
        int newSkyColor = effects.m_47978_();
        if (this.skyColor.isPresent()) {
            newSkyColor = this.skyColor.get();
        }
        builder.m_48040_(newSkyColor);
        Optional<Integer> newFoliageColorOverride = effects.m_47981_();
        if (this.foliageColorOverride.isPresent()) {
            newFoliageColorOverride = this.foliageColorOverride;
        }
        newFoliageColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48043_(arg_0));
        Optional<Integer> newGrassColorOverride = effects.m_47984_();
        if (this.grassColorOverride.isPresent()) {
            newGrassColorOverride = this.grassColorOverride;
        }
        newGrassColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48045_(arg_0));
        BiomeSpecialEffects.GrassColorModifier newGrassColorModifier = effects.m_47987_();
        if (this.grassColorModifier.isPresent()) {
            newGrassColorModifier = this.grassColorModifier.get();
        }
        builder.m_48031_(newGrassColorModifier);
        Optional<AmbientParticleSettings> newParticle = effects.m_47990_();
        if (this.ambientParticleSettings.isPresent()) {
            newParticle = this.ambientParticleSettings;
        }
        newParticle.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48029_(arg_0));
        Optional<SoundEvent> newAmbientSound = effects.m_47993_();
        if (this.ambientLoopSoundEvent.isPresent()) {
            newAmbientSound = this.ambientLoopSoundEvent;
        }
        newAmbientSound.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48023_(arg_0));
        Optional<AmbientMoodSettings> newMood = effects.m_47996_();
        if (this.ambientMoodSettings.isPresent()) {
            newMood = this.ambientMoodSettings;
        }
        newMood.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48027_(arg_0));
        Optional<AmbientAdditionsSettings> newAdditions = effects.m_47999_();
        if (this.ambientAdditionsSettings.isPresent()) {
            newAdditions = this.ambientAdditionsSettings;
        }
        newAdditions.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48025_(arg_0));
        Optional<Music> newMusic = effects.m_48002_();
        if (this.backgroundMusic.isPresent()) {
            newMusic = this.backgroundMusic;
        }
        newMusic.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48021_(arg_0));
        biome.f_47443_ = builder.m_48018_();
        return effects;
    }
}

