/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<ResourceLocation, BiomeSpecialEffects> vanillaEffects = new HashMap<ResourceLocation, BiomeSpecialEffects>();
    private final Map<ResourceLocation, BiomeEffectModifier> effectsToApply = new HashMap<ResourceLocation, BiomeEffectModifier>();

    public BiomeEffectsManager() {
        super("biome_effects");
    }

    @Override
    public void process(Map<ResourceLocation, JsonElement> biomesJsons) {
        for (Map.Entry<ResourceLocation, JsonElement> j : biomesJsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            BiomeEffectModifier effect = (BiomeEffectModifier)((Pair)BiomeEffectModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Biome Special Effect with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.addEffect(id, effect);
        }
    }

    private void addEffect(ResourceLocation pathId, BiomeEffectModifier mod) {
        Optional<Set<ResourceLocation>> explTargets = mod.explicitTargets();
        if (explTargets.isPresent()) {
            for (ResourceLocation explicitId : explTargets.get()) {
                this.effectsToApply.merge(explicitId, mod, BiomeEffectModifier::merge);
            }
        } else {
            this.effectsToApply.merge(pathId, mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void apply() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            this.doApply(level.m_5962_(), false);
        }
    }

    public void doApply(RegistryAccess registryAccess, boolean firstLogin) {
        if (firstLogin) {
            this.vanillaEffects.clear();
        }
        Registry biomeReg = (Registry)registryAccess.m_6632_(Registry.f_122885_).get();
        for (Map.Entry<ResourceLocation, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            ResourceLocation biomeId = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            Optional biome = biomeReg.m_6612_(biomeId);
            if (!biome.isPresent()) continue;
            BiomeSpecialEffects old = modifier.apply((Biome)biome.get());
            this.vanillaEffects.put(biomeId, old);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Override
    public void reset() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            Registry biomeReg = (Registry)level.m_5962_().m_6632_(Registry.f_122885_).get();
            for (Map.Entry<ResourceLocation, BiomeSpecialEffects> v : this.vanillaEffects.entrySet()) {
                Optional biome = biomeReg.m_6612_(v.getKey());
                biome.ifPresent(value -> {
                    value.f_47443_ = (BiomeSpecialEffects)v.getValue();
                });
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
    }
}

