/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.CompoundBlockColors;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.particle.ParticleEmitter;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockPropertiesManager
extends JsonImgPartialReloader {
    private final Map<Block, BlockPropertyModifier> vanillaProperties = new HashMap<Block, BlockPropertyModifier>();
    private final Map<Block, BlockPropertyModifier> modifiers = new HashMap<Block, BlockPropertyModifier>();
    private final Map<Block, List<ParticleEmitter>> particleEmitters = new Object2ObjectOpenHashMap();
    private final Map<ResourceLocation, String> colorPropertiesColormaps = new HashMap<ResourceLocation, String>();

    public BlockPropertiesManager() {
        super("block_properties");
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(ResourceManager resourceManager) {
        HashMap<ResourceLocation, JsonElement> jsons = new HashMap<ResourceLocation, JsonElement>();
        BlockPropertiesManager.scanDirectory(resourceManager, this.path(), GSON, jsons);
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>();
        Map<ResourceLocation, ArrayImage> ofTextures = ArrayImage.gatherImages(resourceManager, "optifine/colormap");
        Map<ResourceLocation, ArrayImage> cmTextures = ArrayImage.gatherImages(resourceManager, "colormatic/colormap");
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(ArrayImage.gatherImages(resourceManager, this.path()));
        return new JsonImgPartialReloader.Resources(jsons, textures);
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources) {
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        Map<ResourceLocation, Int2ObjectMap<ArrayImage>> textures = ArrayImage.groupTextures(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            String[] stringArray;
            JsonElement json = entry.getValue();
            ResourceLocation id = entry.getKey();
            BlockPropertyModifier prop = (BlockPropertyModifier)((Pair)BlockPropertyModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Client Block Property with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            Optional<? extends BlockColor> colormap = prop.tintGetter();
            if (colormap.isPresent() && (stringArray = colormap.get()) instanceof CompoundBlockColors) {
                CompoundBlockColors c = (CompoundBlockColors)stringArray;
                ColormapsManager.fillCompoundColormapPalette(textures, id, c, usedTextures);
            }
            this.addModifier(id, prop);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, JsonElement> entry : textures.entrySet()) {
            Object tintMap;
            ResourceLocation id = entry.getKey();
            Int2ObjectMap value = (Int2ObjectMap)entry.getValue();
            String path = id.m_135815_();
            String special = this.colorPropertiesColormaps.get(id);
            if (special != null) {
                Colormap colormap = Colormap.defTriangle();
                ColormapsManager.tryAcceptingTexture((ArrayImage)textures.get(id).get(-1), id, colormap, new HashSet<ResourceLocation>());
                for (String name : special.split(" ")) {
                    try {
                        ResourceLocation blockId = new ResourceLocation(name);
                        Optional b = Registry.f_122824_.m_6612_(blockId);
                        if (!b.isPresent()) continue;
                        Polytone.VARIANT_TEXTURES.addTintOverrideHack((Block)b.get());
                        this.addModifier(blockId, BlockPropertyModifier.ofColor(colormap));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (path.contains("stem")) {
                Colormap stemMap = Colormap.simple((state, level, pos) -> (float)((Integer)state.m_61143_((Property)StemBlock.f_57013_)).intValue() / 7.0f, IColormapNumberProvider.ZERO);
                Colormap attachedMap = Colormap.simple(IColormapNumberProvider.ONE, IColormapNumberProvider.ZERO);
                ColormapsManager.tryAcceptingTexture((ArrayImage)textures.get(id).get(-1), id, stemMap, usedTextures);
                ColormapsManager.tryAcceptingTexture((ArrayImage)textures.get(id).get(-1), id, attachedMap, usedTextures);
                if (!path.contains("melon")) {
                    this.addModifier(new ResourceLocation("pumpkin_stem"), BlockPropertyModifier.ofColor(stemMap));
                    this.addModifier(new ResourceLocation("attached_pumpkin_stem"), BlockPropertyModifier.ofColor(attachedMap));
                }
                if (path.contains("pumpkin")) continue;
                this.addModifier(new ResourceLocation("melon_stem"), BlockPropertyModifier.ofColor(stemMap));
                this.addModifier(new ResourceLocation("attached_melon_stem"), BlockPropertyModifier.ofColor(attachedMap));
                continue;
            }
            if (path.equals("redstone_wire")) {
                tintMap = Colormap.simple((state, level, pos) -> (float)((Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue() / 15.0f, IColormapNumberProvider.ZERO);
                ColormapsManager.tryAcceptingTexture((ArrayImage)textures.get(id).get(-1), id, tintMap, usedTextures);
                this.addModifier(id, BlockPropertyModifier.ofColor(tintMap));
                continue;
            }
            tintMap = CompoundBlockColors.createDefault((Set<Integer>)value.keySet(), true);
            ColormapsManager.fillCompoundColormapPalette(textures, id, (CompoundBlockColors)tintMap, usedTextures);
            this.addModifier(id, BlockPropertyModifier.ofColor(tintMap));
        }
    }

    private void addModifier(ResourceLocation pathId, BlockPropertyModifier mod) {
        Optional<Set<ResourceLocation>> explTargets = mod.explicitTargets();
        Optional idTarget = Registry.f_122824_.m_6612_(pathId);
        if (explTargets.isPresent()) {
            if (idTarget.isPresent()) {
                Polytone.LOGGER.error("Found Block Properties Modifier with Explicit Targets ({}) also having a valid IMPLICIT Path Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", explTargets.get(), (Object)pathId);
            }
            for (ResourceLocation explicitId : explTargets.get()) {
                Optional target = Registry.f_122824_.m_6612_(explicitId);
                target.ifPresent(block -> this.modifiers.merge((Block)block, mod, BlockPropertyModifier::merge));
            }
        } else {
            idTarget.ifPresent(block -> this.modifiers.merge((Block)block, mod, BlockPropertyModifier::merge));
        }
    }

    @Override
    public void apply() {
        for (Map.Entry<Block, BlockPropertyModifier> e : this.modifiers.entrySet()) {
            Block block = e.getKey();
            BlockPropertyModifier value = e.getValue();
            this.vanillaProperties.put(block, value.apply(block));
            Optional<List<ParticleEmitter>> particle = value.particleEmitters();
            particle.ifPresent(emitters -> this.particleEmitters.put(block, (List<ParticleEmitter>)emitters));
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Block Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }

    @Override
    public void reset() {
        for (Map.Entry<Block, BlockPropertyModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
        }
        this.vanillaProperties.clear();
        this.modifiers.clear();
        this.colorPropertiesColormaps.clear();
        this.particleEmitters.clear();
    }

    public void addSimpleColormap(String path, String str) {
        this.colorPropertiesColormaps.put(new ResourceLocation(path), str);
    }

    public void maybeEmitParticle(Block block, BlockState state, Level level, BlockPos pos) {
        List<ParticleEmitter> m = this.particleEmitters.get(block);
        if (m != null) {
            for (ParticleEmitter p : m) {
                p.tick(level, pos, state);
            }
        }
    }
}

