/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.colormap.CompoundBlockColors;
import net.mehvahdjukaar.polytone.particle.ParticleEmitter;
import net.mehvahdjukaar.polytone.sound.SoundTypesManager;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.TargetsHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MaterialColor;

public record BlockPropertyModifier(Optional<? extends BlockColor> tintGetter, Optional<SoundType> soundType, Optional<Function<BlockState, MaterialColor>> mapColor, Optional<ToIntFunction<BlockState>> clientLight, Optional<List<ParticleEmitter>> particleEmitters, Optional<Set<ResourceLocation>> explicitTargets) {
    public static final Decoder<BlockPropertyModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(CompoundBlockColors.CODEC, "colormap").forGetter(b -> b.tintGetter.flatMap(t -> {
        CompoundBlockColors c;
        return Optional.ofNullable(t instanceof CompoundBlockColors ? (c = (CompoundBlockColors)t) : null);
    })), (App)StrOpt.of(SoundTypesManager.CODEC, "sound_type").forGetter(BlockPropertyModifier::soundType), (App)StrOpt.of(MapColorHelper.CODEC.xmap(c -> a -> c, f -> MaterialColor.f_76398_), "map_color").forGetter(BlockPropertyModifier::mapColor), (App)StrOpt.of(Codec.intRange((int)0, (int)15).xmap(integer -> s -> integer, toIntFunction -> 0), "client_light").forGetter(BlockPropertyModifier::clientLight), (App)StrOpt.of(ParticleEmitter.CODEC.listOf(), "particle_emitters").forGetter(BlockPropertyModifier::particleEmitters), (App)StrOpt.of(TargetsHelper.CODEC, "targets").forGetter(BlockPropertyModifier::explicitTargets)).apply((Applicative)instance, BlockPropertyModifier::new));

    public BlockPropertyModifier merge(BlockPropertyModifier other) {
        return new BlockPropertyModifier(other.tintGetter.isPresent() ? other.tintGetter() : this.tintGetter(), other.soundType().isPresent() ? other.soundType() : this.soundType(), other.mapColor.isPresent() ? other.mapColor() : this.mapColor(), other.clientLight.isPresent() ? other.clientLight : this.clientLight, other.particleEmitters.isPresent() ? other.particleEmitters : this.particleEmitters, TargetsHelper.merge(other.explicitTargets, this.explicitTargets));
    }

    public static BlockPropertyModifier ofColor(BlockColor colormap) {
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public BlockPropertyModifier apply(Block block) {
        SoundType oldSound = null;
        if (this.soundType.isPresent()) {
            oldSound = block.f_60446_;
            block.f_60446_ = this.soundType.get();
        }
        Function oldMapColor = null;
        if (this.mapColor.isPresent()) {
            oldMapColor = block.f_60439_.f_60883_;
            block.f_60439_.f_60883_ = this.mapColor.get();
            for (UnmodifiableIterator s : block.m_49965_().m_61056_()) {
                s.f_60598_ = (MaterialColor)block.f_60439_.f_60883_.apply(s);
            }
        }
        ToIntFunction oldClientLight = null;
        if (this.clientLight.isPresent()) {
            oldClientLight = block.f_60439_.f_60886_;
            block.f_60439_.f_60886_ = this.clientLight.get();
            for (BlockState s : block.m_49965_().m_61056_()) {
                s.f_60594_ = block.f_60439_.f_60886_.applyAsInt(s);
            }
        }
        BlockColor color = null;
        if (this.tintGetter.isPresent()) {
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            color = PlatStuff.getBlockColor(blockColors, block);
            blockColors.m_92589_(this.tintGetter.get(), new Block[]{block});
        }
        return new BlockPropertyModifier(Optional.ofNullable(color), Optional.ofNullable(oldSound), Optional.ofNullable(oldMapColor), Optional.ofNullable(oldClientLight), Optional.empty(), Optional.empty());
    }
}

