/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.SheepAccessor;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.SingleJsonOrPropertiesReloadListener;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.Nullable;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private final Object2IntMap<MaterialColor> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<DyeColor, Integer> vanillaFireworkColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaDiffuseColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaTextColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<ChatFormatting, Integer> vanillaChatFormatting = new EnumMap<ChatFormatting, Integer>(ChatFormatting.class);
    private final Object2IntMap<SpawnEggItem> vanillaEggsBackgrounds = new Object2IntOpenHashMap();
    private final Object2IntMap<SpawnEggItem> vanillaEggsHighlight = new Object2IntOpenHashMap();
    private final Object2IntMap<MobEffect> vanillaEffectColors = new Object2IntOpenHashMap();
    private final Map<DyeColor, Integer> customSheepColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private int emptyPotion = 0xF800F8;
    private int waterBottle = 3694022;

    public ColorManager() {
        super("color.properties", "colors.json", "optifine", "vanadium", "colormatic", "polytone");
    }

    public int getEmptyPot() {
        return this.emptyPotion;
    }

    public int getWaterBottle() {
        return this.waterBottle;
    }

    @Override
    protected void process(List<Properties> list) {
        Lists.reverse(list);
        for (Properties v : list) {
            for (Map.Entry<Object, Object> e : v.entrySet()) {
                Object object = e.getKey();
                if (!(object instanceof String)) continue;
                String key = (String)object;
                String[] split = key.split("\\.");
                this.parseColor(split, e.getValue());
            }
        }
        this.regenSheepColors();
    }

    private void parseColor(String[] prop, Object obj) {
        if (!(obj instanceof String)) {
            return;
        }
        String str = (String)obj;
        if (this.is(prop, 0, "map")) {
            String name = this.get(prop, 1);
            MaterialColor color = MapColorHelper.byName(name);
            if (color != null) {
                int col = ColorManager.parseHex(obj);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.f_76396_);
                }
                color.f_76396_ = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "dye")) {
            String name = this.get(prop, 1);
            DyeColor color = DyeColor.m_41057_((String)name, null);
            if (color != null) {
                String param = this.get(prop, 2);
                int col = ColorManager.parseHex(obj);
                if (param == null || param.equals("diffuse")) {
                    if (!this.vanillaDiffuseColors.containsKey(color)) {
                        this.vanillaDiffuseColors.put(color, ColorUtils.pack(color.f_41039_));
                    }
                    color.f_41039_ = ColorUtils.unpack(col);
                } else if (param.equals("firework")) {
                    if (!this.vanillaFireworkColors.containsKey(color)) {
                        this.vanillaFireworkColors.put(color, color.f_41040_);
                    }
                    color.f_41040_ = col;
                } else if (param.equals("text")) {
                    if (!this.vanillaTextColors.containsKey(color)) {
                        this.vanillaTextColors.put(color, color.f_41041_);
                    }
                    color.f_41041_ = col;
                }
            } else {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "particle")) {
            if (prop.length > 1) {
                ResourceLocation id = new ResourceLocation(prop[1].replace("\\", ""));
                try {
                    int hex = ColorManager.parseHex(str);
                    Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
                }
                catch (Exception e) {
                    Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, str);
                }
            }
        } else if (this.is(prop, 0, "egg")) {
            if (prop.length > 2) {
                EntityType entity;
                ResourceLocation id = new ResourceLocation(prop[2].replace("\\", ""));
                Item item = Registry.f_122827_.m_6612_(id).orElse(null);
                if (item == null) {
                    item = Registry.f_122827_.m_6612_(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_spawn_egg")).orElse(null);
                }
                if (item == null && (entity = (EntityType)Registry.f_122826_.m_6612_(id).orElse(null)) != null) {
                    item = SpawnEggItem.m_43213_((EntityType)entity);
                }
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                    int col = ColorManager.parseHex(obj);
                    if (this.is(prop, 1, "shell")) {
                        if (!this.vanillaEggsBackgrounds.containsKey((Object)spawnEggItem)) {
                            this.vanillaEggsBackgrounds.put((Object)spawnEggItem, spawnEggItem.f_151200_);
                        }
                        spawnEggItem.f_151200_ = col;
                    } else if (this.is(prop, 1, "spots")) {
                        if (!this.vanillaEggsHighlight.containsKey((Object)spawnEggItem)) {
                            this.vanillaEggsHighlight.put((Object)spawnEggItem, spawnEggItem.f_151201_);
                        }
                        spawnEggItem.f_151201_ = col;
                    }
                } else {
                    Polytone.LOGGER.warn("Unknown or invalid Spawn Egg Item with name {}", (Object)id);
                }
            }
        } else if (this.is(prop, 0, "potion") || this.is(prop, 0, "effect")) {
            ResourceLocation id = new ResourceLocation(prop[1].replace("\\", ""));
            int col = ColorManager.parseHex(obj);
            if (id.m_135815_().equals("empty")) {
                this.emptyPotion = col;
            } else if (id.m_135815_().equals("water")) {
                this.waterBottle = col;
            } else {
                MobEffect effect = Registry.f_122823_.m_6612_(id).orElse(null);
                if (effect != null) {
                    if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                        this.vanillaEffectColors.put((Object)effect, effect.m_19484_());
                    }
                    effect.f_19448_ = col;
                } else {
                    Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                }
            }
        } else if (this.is(prop, 0, "sheep")) {
            String name = this.get(prop, 1);
            DyeColor color = DyeColor.m_41057_((String)name, null);
            if (color != null) {
                int col = ColorManager.parseHex(obj);
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "text")) {
            int col = ColorManager.parseHex(obj);
            ChatFormatting text = null;
            if (this.is(prop, 1, "code")) {
                String s = this.get(prop, 2);
                if (s != null) {
                    int code = Integer.parseInt(s);
                    text = ChatFormatting.m_126647_((int)code);
                }
            } else {
                String s = this.get(prop, 1);
                text = ChatFormatting.m_126657_((String)s);
            }
            if (text != null) {
                if (!this.vanillaChatFormatting.containsKey(text)) {
                    this.vanillaChatFormatting.put(text, text.m_126665_());
                }
                text.f_126595_ = col;
            }
        } else if (this.is(prop, 0, "palette") && this.is(prop, 1, "block") && prop.length > 2 && obj instanceof String) {
            String path = prop[2].replace("~/colormap/", "");
            Polytone.BLOCK_PROPERTIES.addSimpleColormap(path, str);
        }
    }

    private boolean is(String[] array, int index, String value) {
        if (array.length <= index) {
            return false;
        }
        return array[index].equals(value);
    }

    @Nullable
    private String get(String[] array, int index) {
        if (array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Nullable
    private <T> T get(String[] array, int index, Function<String, T> fun) {
        if (array.length <= index) {
            return null;
        }
        return fun.apply(array[index]);
    }

    private static int parseHex(Object obj) {
        if (obj instanceof String) {
            String value = (String)obj;
            value = value.replace("#", "").replace("0x", "");
            return Integer.parseInt(value, 16);
        }
        throw new JsonParseException("Failed to parse object " + obj + ". Expected a String");
    }

    @Override
    public void reset() {
        SpawnEggItem item;
        MaterialColor color;
        this.emptyPotion = 0xF800F8;
        this.waterBottle = 3694022;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (MaterialColor)entry.getKey();
            color.f_76396_ = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.f_41039_ = ColorUtils.unpack((Integer)entry.getValue());
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.f_41040_ = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.f_41041_ = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaEggsBackgrounds.entrySet()) {
            item = (SpawnEggItem)entry.getKey();
            item.f_151200_ = (Integer)entry.getValue();
        }
        this.vanillaEggsBackgrounds.clear();
        for (Map.Entry entry : this.vanillaEggsHighlight.entrySet()) {
            item = (SpawnEggItem)entry.getKey();
            item.f_151201_ = (Integer)entry.getValue();
        }
        this.vanillaEggsHighlight.clear();
    }

    public void regenSheepColors() {
        Sheep.f_29801_ = new EnumMap(DyeColor.class);
        for (DyeColor d : DyeColor.values()) {
            Sheep.f_29801_.put(d, SheepAccessor.invokeCreateSheepColor(d));
        }
        for (Map.Entry entry : this.customSheepColors.entrySet()) {
            Sheep.f_29801_.put((DyeColor)entry.getKey(), ColorUtils.unpack((Integer)entry.getValue()));
        }
        this.customSheepColors.clear();
    }
}

