/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Colormap
implements ColorResolver,
BlockColor {
    private final IColormapNumberProvider xGetter;
    private final IColormapNumberProvider yGetter;
    private final boolean triangular;
    private final boolean hasBiomeBlend;
    private final boolean usesBiome;
    private final boolean usesPos;
    private final boolean usesState;
    private Integer defaultColor = null;
    private ArrayImage image = null;
    boolean isReference = false;
    private final ThreadLocal<BlockState> stateHack = new ThreadLocal();
    public static final Codec<Colormap> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(Codec.INT, "default_color").forGetter(c -> Optional.ofNullable(c.defaultColor)), (App)IColormapNumberProvider.CODEC.fieldOf("x_axis").forGetter(c -> c.xGetter), (App)IColormapNumberProvider.CODEC.fieldOf("y_axis").forGetter(c -> c.yGetter), (App)StrOpt.of(Codec.BOOL, "triangular", false).forGetter(c -> c.triangular), (App)StrOpt.of(Codec.BOOL, "biome_blend").forGetter(c -> Optional.of(c.hasBiomeBlend))).apply((Applicative)i, Colormap::new));
    protected static final Codec<BlockColor> REFERENCE_CODEC = ResourceLocation.f_135803_.flatXmap(id -> Optional.ofNullable(Polytone.COLORMAPS.get((ResourceLocation)id)).map(DataResult::success).orElse(DataResult.error((String)("Could not find a custom Colormap with id " + id + " Did you place it in 'assets/[your pack]/polytone/colormaps/' ?"))), object -> Optional.ofNullable(Polytone.COLORMAPS.getKey((BlockColor)object)).map(DataResult::success).orElse(DataResult.error((String)("Unknown Color Property: " + object))));
    public static final Codec<BlockColor> CODEC = new ReferenceOrDirectCodec<BlockColor>(REFERENCE_CODEC, DIRECT_CODEC, i -> {
        if (i instanceof Colormap) {
            Colormap c = (Colormap)i;
            c.isReference = true;
        }
    });

    private Colormap(Optional<Integer> defaultColor, IColormapNumberProvider xGetter, IColormapNumberProvider yGetter, boolean triangular, Optional<Boolean> biomeBlend) {
        this.defaultColor = defaultColor.orElse(null);
        this.xGetter = xGetter;
        this.yGetter = yGetter;
        this.triangular = triangular;
        this.usesBiome = xGetter.usesBiome() || yGetter.usesBiome();
        this.usesPos = this.usesBiome || xGetter.usesPos() || yGetter.usesPos();
        this.usesState = xGetter.usesState() || yGetter.usesState();
        this.hasBiomeBlend = biomeBlend.orElse(this.usesBiome);
    }

    protected Colormap(IColormapNumberProvider xGetter, IColormapNumberProvider yGetter) {
        this(Optional.empty(), xGetter, yGetter, false, Optional.empty());
    }

    public static Colormap simple(IColormapNumberProvider xGetter, IColormapNumberProvider yGetter) {
        return new Colormap(xGetter, yGetter);
    }

    public static Colormap defSquare() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.TEMPERATURE, IColormapNumberProvider.DOWNFALL, false, Optional.empty());
    }

    public static Colormap defTriangle() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.TEMPERATURE, IColormapNumberProvider.DOWNFALL, true, Optional.empty());
    }

    public void acceptTexture(ArrayImage image) {
        this.image = image;
        if (this.defaultColor == null) {
            this.defaultColor = this.sample(0.5f, 0.5f, -1);
        }
    }

    public int m_92566_(@Nullable BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int i) {
        if (level == null) {
            return this.defaultColor;
        }
        if (pos == null && (this.usesPos || this.usesBiome)) {
            return this.defaultColor;
        }
        if (state == null && this.usesState) {
            return this.defaultColor;
        }
        if (this.hasBiomeBlend) {
            this.stateHack.set(state);
            if (Polytone.sodiumOn && level instanceof LevelReader) {
                LevelReader r = (LevelReader)level;
                return this.sampleColor(state, pos, (Biome)r.m_204166_(pos).m_203334_());
            }
            return level.m_6171_(pos, (ColorResolver)this);
        }
        return this.sampleColor(state, pos, null);
    }

    private int sampleColor(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome) {
        float humidity = Mth.m_14036_((float)this.xGetter.getValue(state, pos, biome), (float)0.0f, (float)1.0f);
        float temperature = Mth.m_14036_((float)this.yGetter.getValue(state, pos, biome), (float)0.0f, (float)1.0f);
        return this.sample(humidity, temperature, this.defaultColor);
    }

    public int m_130045_(Biome biome, double x, double y) {
        return 0;
    }

    public int calculateBlendedColor(Level level, BlockPos pos) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        BlockState state = this.stateHack.get();
        if (i == 0) {
            return this.sampleColor(state, pos, (Biome)level.m_204166_(pos).m_203334_());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        Cursor3D cursor3D = new Cursor3D(pos.m_123341_() - i, pos.m_123342_(), pos.m_123343_() - i, pos.m_123341_() + i, pos.m_123342_(), pos.m_123343_() + i);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        while (cursor3D.m_122304_()) {
            mutableBlockPos.m_122178_(cursor3D.m_122305_(), cursor3D.m_122306_(), cursor3D.m_122307_());
            int n = this.sampleColor(state, (BlockPos)mutableBlockPos, (Biome)level.m_204166_((BlockPos)mutableBlockPos).m_203334_());
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }

    private int sample(float x, float y, int defValue) {
        if (this.triangular) {
            x *= y;
        }
        int width = this.image.width();
        int height = this.image.height();
        int w = (int)((1.0 - (double)y) * (double)(width - 1));
        int h = (int)((1.0 - (double)x) * (double)(height - 1));
        return w >= width || h >= height ? defValue : this.image.pixels()[h][w];
    }
}

