/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.CompoundBlockColors;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import org.jetbrains.annotations.Nullable;

public class ColormapsManager
extends JsonImgPartialReloader {
    public static final BlockColor GRASS_COLOR = (s, l, p, i) -> l != null && p != null ? BiomeColors.m_108793_((BlockAndTintGetter)l, (BlockPos)p) : GrassColor.m_46415_((double)0.5, (double)1.0);
    public static final BlockColor FOLIAGE_COLOR = (s, l, p, i) -> l != null && p != null ? BiomeColors.m_108804_((BlockAndTintGetter)l, (BlockPos)p) : FoliageColor.m_46113_();
    public static final BlockColor WATER_COLOR = (s, l, p, i) -> l != null && p != null ? BiomeColors.m_108811_((BlockAndTintGetter)l, (BlockPos)p) : -16777216;
    public static final BlockColor BIOME_SAMPLE = Colormap.defSquare();
    public static final BlockColor TR_BIOME_SAMPLE = Colormap.defTriangle();
    private final BiMap<ResourceLocation, BlockColor> colormapsIds = HashBiMap.create();

    public ColormapsManager() {
        super("colormaps");
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources) {
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        Map<ResourceLocation, ArrayImage> textures = resources.textures();
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id = entry.getKey();
            Colormap colormap = (Colormap)((Pair)Colormap.DIRECT_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Colormap with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            ColormapsManager.tryAcceptingTexture(textures.get(id), id, colormap, usedTextures);
            this.add(id, colormap);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, Object> entry : textures.entrySet()) {
            ResourceLocation id = entry.getKey();
            Colormap defaultColormap = Colormap.defTriangle();
            ColormapsManager.tryAcceptingTexture(textures.get(id), id, defaultColormap, usedTextures);
            this.add(id, defaultColormap);
        }
    }

    @Override
    public void reset() {
        this.colormapsIds.clear();
        this.colormapsIds.put((Object)new ResourceLocation("grass_color"), (Object)GRASS_COLOR);
        this.colormapsIds.put((Object)new ResourceLocation("foliage_color"), (Object)FOLIAGE_COLOR);
        this.colormapsIds.put((Object)new ResourceLocation("water_color"), (Object)WATER_COLOR);
        this.colormapsIds.put((Object)new ResourceLocation("biome_sample"), (Object)BIOME_SAMPLE);
        this.colormapsIds.put((Object)new ResourceLocation("triangular_biome_sample"), (Object)TR_BIOME_SAMPLE);
    }

    @Nullable
    public BlockColor get(ResourceLocation id) {
        return (BlockColor)this.colormapsIds.get((Object)id);
    }

    @Nullable
    public ResourceLocation getKey(BlockColor object) {
        return (ResourceLocation)this.colormapsIds.inverse().get((Object)object);
    }

    public void add(ResourceLocation id, Colormap colormap) {
        this.colormapsIds.put((Object)id, (Object)colormap);
    }

    public static void fillCompoundColormapPalette(Map<ResourceLocation, Int2ObjectMap<ArrayImage>> textures, ResourceLocation id, CompoundBlockColors colormap, Set<ResourceLocation> usedTextures) {
        Int2ObjectMap<BlockColor> getters = colormap.getGetters();
        Int2ObjectMap<ArrayImage> textureMap = textures.get(id);
        for (Int2ObjectMap.Entry g : getters.int2ObjectEntrySet()) {
            int index = g.getIntKey();
            BlockColor inner = (BlockColor)g.getValue();
            if (!(inner instanceof Colormap)) continue;
            Colormap c = (Colormap)inner;
            if (c.isReference || textureMap == null || getters.size() != 1 && index != 0) continue;
            try {
                ColormapsManager.tryAcceptingTexture((ArrayImage)textureMap.get(-1), id, c, usedTextures);
            }
            catch (Exception exception) {
                try {
                    ColormapsManager.tryAcceptingTexture((ArrayImage)textureMap.get(index), id, c, usedTextures);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed applying a texture for tint index " + index + ": ", e);
                }
            }
        }
    }

    public static void tryAcceptingTexture(@Nullable ArrayImage texture, ResourceLocation path, Colormap colormap, Set<ResourceLocation> usedTexture) {
        if (texture != null) {
            usedTexture.add(path);
            colormap.acceptTexture(texture);
            if (texture.pixels().length == 0) {
                throw new IllegalStateException("Colormap at location " + path + " had invalid 0 dimension");
            }
        } else {
            throw new IllegalStateException("Could not find any colormap associated with path " + path);
        }
    }
}

