/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.lightmap.Lightmap;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CompoundBlockColors
implements BlockColor {
    final Int2ObjectMap<BlockColor> getters = new Int2ObjectArrayMap();
    protected static final Codec<CompoundBlockColors> DIRECT_CODEC = Lightmap.validate(Codec.simpleMap((Codec)Codec.STRING, Colormap.CODEC, (Keyable)Keyable.forStrings(() -> IntStream.rangeClosed(-1, 16).mapToObj(String::valueOf))).xmap(CompoundBlockColors::new, CompoundBlockColors::toStringMap).codec(), c -> {
        if (c.getters.size() == 0) {
            return DataResult.error((String)"Must have at least 1 tint getter");
        }
        return DataResult.success((Object)c);
    });
    public static final Codec<BlockColor> CODEC = Codec.either(DIRECT_CODEC, Colormap.CODEC).xmap(either -> (BlockColor)either.map(Function.identity(), CompoundBlockColors::new), Either::right);

    private CompoundBlockColors(Map<String, BlockColor> map) {
        for (Map.Entry<String, BlockColor> e : map.entrySet()) {
            this.getters.put(Integer.parseInt(e.getKey()), (Object)e.getValue());
        }
    }

    private CompoundBlockColors() {
    }

    public CompoundBlockColors(BlockColor colormap) {
        this.getters.put(-1, (Object)colormap);
    }

    public static CompoundBlockColors createDefault(Set<Integer> tintIndexes, boolean triangular) {
        CompoundBlockColors c = new CompoundBlockColors();
        for (Integer i : tintIndexes) {
            c.getters.put(i.intValue(), (Object)(triangular ? Colormap.defTriangle() : Colormap.defSquare()));
        }
        return c;
    }

    public Int2ObjectMap<BlockColor> getGetters() {
        return this.getters;
    }

    public Map<String, BlockColor> toStringMap() {
        return this.getters.int2ObjectEntrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getIntKey()), Map.Entry::getValue));
    }

    public int m_92566_(@Nullable BlockState blockState, @Nullable BlockAndTintGetter level, @Nullable BlockPos blockPos, int tintIndex) {
        BlockColor getter = (BlockColor)this.getters.get(tintIndex);
        if (getter == null) {
            getter = (BlockColor)this.getters.get(-1);
        }
        if (getter != null) {
            return getter.m_92566_(blockState, level, blockPos, tintIndex);
        }
        return -1;
    }
}

