/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.fluid.forge.FluidPropertiesManagerImpl;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class FluidPropertiesManager
extends JsonImgPartialReloader {
    private final Map<Fluid, FluidPropertyModifier> modifiers = new HashMap<Fluid, FluidPropertyModifier>();

    public FluidPropertiesManager() {
        super("fluid_properties");
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(ResourceManager resourceManager) {
        HashMap<ResourceLocation, JsonElement> jsons = new HashMap<ResourceLocation, JsonElement>();
        FluidPropertiesManager.scanDirectory(resourceManager, this.path(), GSON, jsons);
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>();
        Map<ResourceLocation, ArrayImage> ofTextures = ArrayImage.gatherImages(resourceManager, "optifine/colormap");
        Map<ResourceLocation, ArrayImage> cmTextures = ArrayImage.gatherImages(resourceManager, "colormatic/colormap");
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(ArrayImage.gatherImages(resourceManager, this.path()));
        return new JsonImgPartialReloader.Resources(jsons, textures);
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources) {
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        Map<ResourceLocation, ArrayImage> textures = resources.textures();
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id = entry.getKey();
            FluidPropertyModifier modifier = (FluidPropertyModifier)((Pair)FluidPropertyModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Fluid Color Modifier with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            BlockColor colormap = modifier.colormap().orElse(null);
            if (colormap instanceof Colormap) {
                Colormap c = (Colormap)colormap;
                ColormapsManager.tryAcceptingTexture(textures.get(id), id, c, usedTextures);
            }
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, Object> entry : textures.entrySet()) {
            ResourceLocation id = entry.getKey();
            Colormap defaultColormap = Colormap.defTriangle();
            ColormapsManager.tryAcceptingTexture(textures.get(id), id, defaultColormap, usedTextures);
            this.addModifier(id, new FluidPropertyModifier(Optional.of(defaultColormap), Optional.empty(), Optional.empty()));
        }
    }

    @Override
    protected void reset() {
        this.modifiers.clear();
        FluidPropertiesManager.clearSpecial();
    }

    private void addModifier(ResourceLocation pathId, FluidPropertyModifier mod) {
        Optional<Set<ResourceLocation>> explTargets = mod.explicitTargets();
        Optional pathTarget = Registry.f_122822_.m_6612_(pathId);
        if (explTargets.isPresent()) {
            if (pathTarget.isPresent()) {
                Polytone.LOGGER.error("Found Fluid Properties Modifier with Explicit Targets ({}) also having a valid IMPLICIT Path Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", explTargets.get(), (Object)pathId);
            }
            for (ResourceLocation explicitId : explTargets.get()) {
                Optional target = Registry.f_122822_.m_6612_(explicitId);
                target.ifPresent(fluid -> this.modifiers.merge((Fluid)fluid, mod, FluidPropertyModifier::merge));
                FluidPropertiesManager.tryAddSpecial(explicitId, mod);
            }
        } else {
            pathTarget.ifPresent(block -> this.modifiers.merge((Fluid)block, mod, FluidPropertyModifier::merge));
            FluidPropertiesManager.tryAddSpecial(pathId, mod);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void tryAddSpecial(ResourceLocation id, FluidPropertyModifier colormap) {
        void var1_1;
        FluidPropertiesManagerImpl.tryAddSpecial(id, (FluidPropertyModifier)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void clearSpecial() {
        FluidPropertiesManagerImpl.clearSpecial();
    }

    public int modifyColor(int original, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, FluidState fluidState) {
        BlockColor col;
        FluidPropertyModifier modifier = this.modifiers.get(fluidState.m_76152_());
        if (modifier != null && (col = modifier.getColormap()) != null) {
            return col.m_92566_(state, level, pos, -1) | 0x44000000;
        }
        return original;
    }
}

