/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.colormap.CompoundBlockColors;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.TargetsHelper;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record FluidPropertyModifier(Optional<BlockColor> colormap, Optional<BlockColor> fogColormap, Optional<Set<ResourceLocation>> explicitTargets) {
    public static final Decoder<FluidPropertyModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(CompoundBlockColors.CODEC, "colormap").forGetter(FluidPropertyModifier::colormap), (App)StrOpt.of(CompoundBlockColors.CODEC, "fog_colormap").forGetter(FluidPropertyModifier::fogColormap), (App)StrOpt.of(TargetsHelper.CODEC, "targets").forGetter(FluidPropertyModifier::explicitTargets)).apply((Applicative)instance, FluidPropertyModifier::new));

    public FluidPropertyModifier merge(FluidPropertyModifier other) {
        return new FluidPropertyModifier(other.colormap.isPresent() ? other.colormap() : this.colormap(), other.fogColormap().isPresent() ? other.fogColormap() : this.fogColormap(), TargetsHelper.merge(other.explicitTargets, this.explicitTargets));
    }

    @Nullable
    public BlockColor getColormap() {
        return this.colormap.orElse(null);
    }

    @Nullable
    public BlockColor getFogColormap() {
        return this.fogColormap.orElse(null);
    }
}

