/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid.forge;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPropertiesManagerImpl {
    private static final Map<FluidType, IClientFluidTypeExtensions> FLUID_EXTENSIONS = new HashMap<FluidType, IClientFluidTypeExtensions>();

    public static void tryAddSpecial(ResourceLocation id, FluidPropertyModifier colormap) {
        FluidType fluid = (FluidType)((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getValue(id);
        if (fluid != null) {
            IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((FluidType)fluid);
            if (ext instanceof FluidExtensionWrapper) {
                Polytone.LOGGER.error("Trying to wrap a wrapper. Something went wrong");
            }
            FLUID_EXTENSIONS.put(fluid, new FluidExtensionWrapper(ext, colormap));
        }
    }

    public static void clearSpecial() {
        FLUID_EXTENSIONS.clear();
    }

    @Nullable
    public static IClientFluidTypeExtensions maybeGetWrappedExtension(FluidType ft) {
        if (!FLUID_EXTENSIONS.isEmpty()) {
            return FLUID_EXTENSIONS.get(ft);
        }
        return null;
    }

    private record FluidExtensionWrapper(IClientFluidTypeExtensions instance, FluidPropertyModifier modifier) implements IClientFluidTypeExtensions
    {
        public int getTintColor() {
            BlockColor col = this.modifier.getColormap();
            if (col != null) {
                return col.m_92566_(null, null, null, -1) | 0xFF000000;
            }
            return this.instance.getTintColor();
        }

        public int getTintColor(FluidStack stack) {
            BlockColor col = this.modifier.getColormap();
            if (col != null) {
                return col.m_92566_(null, null, null, -1) | 0xFF000000;
            }
            return this.instance.getTintColor();
        }

        public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            BlockColor col = this.modifier.getColormap();
            if (col != null) {
                return col.m_92566_(state.m_76188_(), getter, pos, -1) | 0xFF000000;
            }
            return this.instance.getTintColor();
        }

        public ResourceLocation getStillTexture() {
            return this.instance.getStillTexture();
        }

        public ResourceLocation getFlowingTexture() {
            return this.instance.getFlowingTexture();
        }

        @Nullable
        public ResourceLocation getOverlayTexture() {
            return this.instance.getOverlayTexture();
        }

        @Nullable
        public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
            return this.instance.getRenderOverlayTexture(mc);
        }

        public void renderOverlay(Minecraft mc, PoseStack poseStack) {
            this.instance.renderOverlay(mc, poseStack);
        }

        @NotNull
        public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
            return this.instance.modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, fluidFogColor);
        }

        public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
            this.instance.modifyFogRender(camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape);
        }

        public ResourceLocation getStillTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return this.instance.getStillTexture(state, getter, pos);
        }

        public ResourceLocation getFlowingTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return this.instance.getFlowingTexture(state, getter, pos);
        }

        public ResourceLocation getOverlayTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return this.instance.getOverlayTexture(state, getter, pos);
        }

        public ResourceLocation getStillTexture(FluidStack stack) {
            return this.instance.getStillTexture(stack);
        }

        public ResourceLocation getOverlayTexture(FluidStack stack) {
            return this.instance.getOverlayTexture(stack);
        }

        public ResourceLocation getFlowingTexture(FluidStack stack) {
            return this.instance.getFlowingTexture(stack);
        }
    }
}

