/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import net.mehvahdjukaar.polytone.lightmap.LightmapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public interface ILightmapNumberProvider {
    public static final BiMap<String, ILightmapNumberProvider> CUSTOM_PROVIDERS = HashBiMap.create();
    public static final Codec<ILightmapNumberProvider> REFERENCE_CODEC = ExtraCodecs.m_184405_(a -> (String)CUSTOM_PROVIDERS.inverse().get(a), arg_0 -> CUSTOM_PROVIDERS.get(arg_0));
    public static final Codec<ILightmapNumberProvider> CODEC = new ReferenceOrDirectCodec<LightmapExpressionProvider>(REFERENCE_CODEC, LightmapExpressionProvider.CODEC, true);
    public static final RandomSource RAND = RandomSource.m_216327_();
    public static final ILightmapNumberProvider RANDOM = ILightmapNumberProvider.register("random", (time, rain, thunder) -> {
        RAND.m_188584_((long)Float.floatToIntBits(time));
        return RAND.m_188501_();
    });
    public static final ILightmapNumberProvider DEFAULT = ILightmapNumberProvider.register("default", (time, rain, thunder) -> {
        float g = 1.0f - (Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        g = 1.0f - g;
        return g;
    });
    public static final ILightmapNumberProvider SMOOTH = ILightmapNumberProvider.register("smooth", (time, rain, thunder) -> 0.5f + Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.5f);
    public static final ILightmapNumberProvider LINEAR = ILightmapNumberProvider.register("linear", (time, rain, thunder) -> Mth.m_14154_((float)(1.0f - 2.0f * time)));
    public static final ILightmapNumberProvider DEFAULT_2 = ILightmapNumberProvider.register("default", (time, rain, thunder) -> {
        float g = 1.0f - (Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        g = 1.0f - g;
        g = (float)((double)g * 0.5);
        if ((double)time > 0.5) {
            return g;
        }
        return 1.0f - g;
    });
    public static final ILightmapNumberProvider SMOOTH_2 = ILightmapNumberProvider.register("smooth_2", (time, rain, thunder) -> {
        if ((double)time > 0.5) {
            return 0.25f - Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.25f;
        }
        return 0.75f + Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.25f;
    });
    public static final ILightmapNumberProvider LINEAR_2 = ILightmapNumberProvider.register("linear_2", (time, rain, thunder) -> {
        float linear = Mth.m_14154_((float)(1.0f - 2.0f * time));
        if ((double)time > 0.5) {
            return linear * 0.5f;
        }
        return 1.0f - linear * 0.5f;
    });

    public static <T extends ILightmapNumberProvider> T register(String name, T provider) {
        CUSTOM_PROVIDERS.put((Object)name, provider);
        return provider;
    }

    public float getValue(float var1, float var2, float var3);
}

